/*
 * Decompiled with CFR 0.152.
 */
package com.github.fabienbarbero.plugins.mkdocs;

import com.github.fabienbarbero.plugins.mkdocs.AbstractMkdocsMojo;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="gh-deploy", defaultPhase=LifecyclePhase.DEPLOY)
public class GithubDeployMojo
extends AbstractMkdocsMojo {
    @Parameter(defaultValue="Updating github page with Mkdocs documentation")
    private String commitMessage;
    @Parameter(defaultValue="gh-pages")
    private String remoteBranch;

    public void execute() throws MojoExecutionException {
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("mkdocs");
            args.add("gh-deploy");
            args.add("-f");
            args.add(this.configFile.getCanonicalPath());
            args.add("-m");
            args.add(this.commitMessage);
            args.add("-b");
            args.add(this.remoteBranch);
            if (this.getLog().isDebugEnabled()) {
                args.add("-v");
            }
            ProcessBuilder builder = new ProcessBuilder(args);
            builder.directory(this.configFile.getParentFile());
            Process proc = builder.start();
            this.dumpLogs(proc);
            int status = proc.waitFor();
            if (status != 0) {
                throw new MojoExecutionException("Mkdocs documentation deploy has failed with status " + status);
            }
        }
        catch (IOException | InterruptedException ex) {
            throw new MojoExecutionException("Error deploying mkdocs documentation", ex);
        }
    }
}

