/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.UuidFactory;
import com.github.f4b6a3.uuid.factory.function.impl.DefaultRandomFunction;
import com.github.f4b6a3.uuid.util.internal.ByteUtil;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.IntFunction;
import java.util.function.LongSupplier;

public abstract class AbstRandomBasedFactory
extends UuidFactory {
    protected final IRandom random;
    protected static final int UUID_BYTES = 16;
    protected final ReentrantLock lock = new ReentrantLock();

    protected AbstRandomBasedFactory(UuidVersion version, Builder<?, ?> builder) {
        super(version);
        this.random = builder.getRandom();
    }

    @Override
    public UUID create(UuidFactory.Parameters parameters) {
        return this.create();
    }

    protected static final class SafeRandom
    implements IRandom {
        private final IntFunction<byte[]> randomFunction;

        public SafeRandom() {
            this(SafeRandom.newSafeFunction(null));
        }

        public SafeRandom(Random random) {
            this(SafeRandom.newSafeFunction(Objects.requireNonNull(random)));
        }

        public SafeRandom(IntFunction<byte[]> randomFunction) {
            this.randomFunction = Objects.requireNonNull(randomFunction);
        }

        @Override
        public long nextLong() {
            byte[] bytes = this.randomFunction.apply(8);
            return ByteUtil.toNumber(bytes);
        }

        @Override
        public byte[] nextBytes(int length) {
            return this.randomFunction.apply(length);
        }

        private static IntFunction<byte[]> newSafeFunction(Random random) {
            Random entropy = random != null ? random : new SecureRandom();
            return length -> {
                byte[] bytes = new byte[length];
                entropy.nextBytes(bytes);
                return bytes;
            };
        }
    }

    protected static final class FastRandom
    implements IRandom {
        private final LongSupplier randomFunction;

        public FastRandom() {
            this(FastRandom.newFastFunction(null));
        }

        public FastRandom(Random random) {
            this(FastRandom.newFastFunction(Objects.requireNonNull(random)));
        }

        public FastRandom(LongSupplier randomFunction) {
            this.randomFunction = Objects.requireNonNull(randomFunction);
        }

        @Override
        public long nextLong() {
            return this.randomFunction.getAsLong();
        }

        @Override
        public byte[] nextBytes(int length) {
            int shift = 0;
            long random = 0L;
            byte[] bytes = new byte[length];
            for (int i = 0; i < length; ++i) {
                if (shift < 8) {
                    shift = 64;
                    random = this.randomFunction.getAsLong();
                }
                bytes[i] = (byte)(random >>> (shift -= 8));
            }
            return bytes;
        }

        private static LongSupplier newFastFunction(Random random) {
            if (random != null) {
                return () -> random.nextLong();
            }
            return () -> ThreadLocalRandom.current().nextLong();
        }
    }

    protected static interface IRandom {
        public long nextLong();

        public byte[] nextBytes(int var1);
    }

    protected static abstract class Builder<T, B extends Builder<T, B>> {
        protected IRandom random;

        protected Builder() {
        }

        protected IRandom getRandom() {
            if (this.random == null) {
                this.random = new SafeRandom(new DefaultRandomFunction());
            }
            return this.random;
        }

        public B withFastRandom() {
            this.random = new FastRandom();
            return (B)this;
        }

        public B withSafeRandom() {
            this.random = new SafeRandom();
            return (B)this;
        }

        public B withRandom(Random random) {
            if (random != null) {
                this.random = random instanceof SecureRandom ? new SafeRandom(random) : new FastRandom(random);
            }
            return (B)this;
        }

        public B withRandomFunction(LongSupplier randomFunction) {
            this.random = new FastRandom(randomFunction);
            return (B)this;
        }

        public abstract T build();
    }
}

