/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

import com.github.f4b6a3.uuid.util.UuidUtil;
import com.github.f4b6a3.uuid.util.internal.ByteUtil;
import com.github.f4b6a3.uuid.util.internal.NetworkUtil;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

public final class MachineId {
    private static Long id;
    private static UUID uuid;
    private static String hexa;
    private static byte[] hash;
    private static String string;

    private MachineId() {
    }

    public static long getMachineId() {
        if (id == null) {
            byte[] bytes = MachineId.getMachineHash();
            id = ByteUtil.toNumber(bytes, 0, 8);
        }
        return id;
    }

    public static UUID getMachineUuid() {
        if (uuid == null) {
            byte[] bytes = MachineId.getMachineHash();
            long msb = ByteUtil.toNumber(bytes, 0, 8);
            long lsb = ByteUtil.toNumber(bytes, 8, 16);
            uuid = UuidUtil.setVersion(new UUID(msb, lsb), 4);
        }
        return uuid;
    }

    public static String getMachineHexa() {
        if (hexa == null) {
            byte[] bytes = MachineId.getMachineHash();
            hexa = ByteUtil.toHexadecimal(bytes);
        }
        return hexa;
    }

    public static byte[] getMachineHash() {
        if (hash == null) {
            try {
                String string = MachineId.getMachineString();
                hash = MessageDigest.getInstance("SHA-256").digest(string.getBytes(StandardCharsets.UTF_8));
            }
            catch (NoSuchAlgorithmException e) {
                throw new InternalError("Message digest algorithm not supported.", e);
            }
        }
        return hash;
    }

    public static String getMachineString() {
        if (string == null) {
            string = NetworkUtil.getMachineString();
        }
        return string;
    }
}

