/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.rfc4122;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.AbstTimeBasedFactory;

public final class TimeOrderedFactory
extends AbstTimeBasedFactory {
    public TimeOrderedFactory() {
        this(TimeOrderedFactory.builder());
    }

    private TimeOrderedFactory(Builder builder) {
        super(UuidVersion.VERSION_TIME_ORDERED, builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected long formatMostSignificantBits(long timestamp) {
        return (timestamp & 0xFFFFFFFFFFFF000L) << 4 | timestamp & 0xFFFL | 0x6000L;
    }

    public static class Builder
    extends AbstTimeBasedFactory.Builder<TimeOrderedFactory, Builder> {
        @Override
        public TimeOrderedFactory build() {
            return new TimeOrderedFactory(this);
        }
    }
}

