/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.rfc4122;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.AbstCombFactory;
import com.github.f4b6a3.uuid.factory.function.RandomFunction;
import com.github.f4b6a3.uuid.util.internal.ByteUtil;
import java.time.Clock;
import java.util.Random;
import java.util.UUID;
import java.util.function.LongSupplier;

public final class TimeOrderedEpochFactory
extends AbstCombFactory {
    private long lastTime;
    private UUID lastUuid;
    private final int incrementType;
    private final LongSupplier incrementSupplier;
    private static final int INCREMENT_TYPE_DEFAULT = 0;
    private static final int INCREMENT_TYPE_PLUS_1 = 1;
    private static final int INCREMENT_TYPE_PLUS_N = 2;
    protected static final int CLOCK_DRIFT_TOLERANCE = 10000;
    public static final int RANDOM_BYTES = 10;

    public TimeOrderedEpochFactory() {
        this(TimeOrderedEpochFactory.builder());
    }

    public TimeOrderedEpochFactory(Clock clock) {
        this(TimeOrderedEpochFactory.builder().withClock(clock));
    }

    public TimeOrderedEpochFactory(Random random) {
        this(TimeOrderedEpochFactory.builder().withRandom(random));
    }

    public TimeOrderedEpochFactory(Random random, Clock clock) {
        this(TimeOrderedEpochFactory.builder().withRandom(random).withClock(clock));
    }

    public TimeOrderedEpochFactory(RandomFunction randomFunction) {
        this(TimeOrderedEpochFactory.builder().withRandomFunction(randomFunction));
    }

    public TimeOrderedEpochFactory(RandomFunction randomFunction, Clock clock) {
        this(TimeOrderedEpochFactory.builder().withRandomFunction(randomFunction).withClock(clock));
    }

    private TimeOrderedEpochFactory(Builder builder) {
        super(UuidVersion.VERSION_TIME_ORDERED_EPOCH, builder);
        this.incrementType = builder.getIncrementType();
        this.incrementSupplier = builder.getIncrementSupplier();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public synchronized UUID create() {
        long time = this.clock.millis();
        if (time > this.lastTime - 10000L && time <= this.lastTime) {
            this.lastUuid = this.increment(this.lastUuid);
        } else {
            this.lastTime = time;
            this.lastUuid = this.make(time, (byte[])this.randomFunction.apply(10));
        }
        return this.copy(this.lastUuid);
    }

    private synchronized UUID increment(UUID uuid) {
        long overflow = 0L;
        long versionMask = 61440L;
        long variantMask = -4611686018427387904L;
        long msb = uuid.getMostSignificantBits() | 0xF000L;
        long lsb = (uuid.getLeastSignificantBits() | 0xC000000000000000L) + this.incrementSupplier.getAsLong();
        if (0 == this.incrementType) {
            long clearMask = -281474976710656L;
            if ((lsb & 0xFFFF000000000000L) == 0L) {
                ++msb;
            }
            lsb &= 0xFFFF000000000000L;
            lsb |= ByteUtil.toNumber((byte[])this.randomFunction.apply(6));
        } else if (lsb == 0L) {
            ++msb;
        }
        return this.toUuid(msb, lsb);
    }

    private synchronized UUID make(long time, byte[] random) {
        long msb = 0L;
        long lsb = 0L;
        msb |= time << 16;
        msb |= ((long)random[0] & 0xFFL) << 8;
        msb |= (long)random[1] & 0xFFL;
        lsb |= ((long)random[2] & 0xFFL) << 56;
        lsb |= ((long)random[3] & 0xFFL) << 48;
        lsb |= ((long)random[4] & 0xFFL) << 40;
        lsb |= ((long)random[5] & 0xFFL) << 32;
        lsb |= ((long)random[6] & 0xFFL) << 24;
        lsb |= ((long)random[7] & 0xFFL) << 16;
        lsb |= ((long)random[8] & 0xFFL) << 8;
        return this.toUuid(msb, lsb |= (long)random[9] & 0xFFL);
    }

    private synchronized UUID copy(UUID uuid) {
        return this.toUuid(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public static class Builder
    extends AbstCombFactory.Builder<TimeOrderedEpochFactory> {
        private Integer incrementType;
        private Long incrementMax;

        public Builder withClock(Clock clock) {
            return (Builder)super.withClock(clock);
        }

        public Builder withRandom(Random random) {
            return (Builder)super.withRandom(random);
        }

        public Builder withRandomFunction(RandomFunction randomFunction) {
            return (Builder)super.withRandomFunction(randomFunction);
        }

        public Builder withIncrementPlus1() {
            this.incrementType = 1;
            this.incrementMax = null;
            return this;
        }

        public Builder withIncrementPlusN() {
            this.incrementType = 2;
            this.incrementMax = null;
            return this;
        }

        public Builder withIncrementPlusN(long incrementMax) {
            this.incrementType = 2;
            this.incrementMax = incrementMax;
            return this;
        }

        public int getIncrementType() {
            if (this.incrementType == null) {
                this.incrementType = 0;
            }
            return this.incrementType;
        }

        public LongSupplier getIncrementSupplier() {
            switch (this.getIncrementType()) {
                case 1: {
                    return () -> 1L;
                }
                case 2: {
                    if (this.incrementMax == null) {
                        return () -> {
                            byte[] bytes = (byte[])this.randomFunction.apply(4);
                            return ByteUtil.toNumber(bytes, 0, 4) + 1L;
                        };
                    }
                    int bits = (int)Math.ceil(Math.log(this.incrementMax.longValue()) / Math.log(2.0));
                    int size = (bits - 1) / 8 + 1;
                    return () -> {
                        byte[] bytes = (byte[])this.randomFunction.apply(size);
                        long random = ByteUtil.toNumber(bytes, 0, size);
                        return random % this.incrementMax + 1L;
                    };
                }
            }
            return () -> 0x1000000000000L;
        }

        @Override
        public TimeOrderedEpochFactory build() {
            return new TimeOrderedEpochFactory(this);
        }
    }
}

