/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.rfc4122;

import com.github.f4b6a3.uuid.enums.UuidLocalDomain;
import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.AbstTimeBasedFactory;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public final class DceSecurityFactory
extends AbstTimeBasedFactory {
    private AtomicInteger counter;
    private final byte localDomain;

    public DceSecurityFactory() {
        this(DceSecurityFactory.builder());
    }

    private DceSecurityFactory(Builder builder) {
        super(UuidVersion.VERSION_DCE_SECURITY, builder);
        this.localDomain = builder != null ? builder.localDomain : (byte)0;
        this.counter = new AtomicInteger();
    }

    public static Builder builder() {
        return new Builder();
    }

    public synchronized UUID create(byte localDomain, int localIdentifier) {
        UUID uuid = super.create();
        long msb = DceSecurityFactory.setLocalIdentifierBits(uuid.getMostSignificantBits(), localIdentifier);
        long lsb = DceSecurityFactory.setLocalDomainBits(uuid.getLeastSignificantBits(), localDomain, this.counter.incrementAndGet());
        return this.toUuid(msb, lsb);
    }

    public synchronized UUID create(UuidLocalDomain localDomain, int localIdentifier) {
        return this.create(localDomain.getValue(), localIdentifier);
    }

    public synchronized UUID create(int localIdentifier) {
        return this.create(this.localDomain, localIdentifier);
    }

    @Override
    public synchronized UUID create() {
        throw new UnsupportedOperationException("Unsuported operation for DCE Security UUID factory");
    }

    private static long setLocalIdentifierBits(long msb, int localIdentifier) {
        return msb & 0xFFFFFFFFL | ((long)localIdentifier & 0xFFFFFFFFL) << 32;
    }

    private static long setLocalDomainBits(long lsb, byte localDomain, long counter) {
        return lsb & 0xFFFFFFFFFFFFL | ((long)localDomain & 0xFFL) << 48 | (counter & 0xFFL) << 56;
    }

    public static class Builder
    extends AbstTimeBasedFactory.Builder<DceSecurityFactory> {
        private byte localDomain;

        public Builder withLocalDomain(UuidLocalDomain localDomain) {
            this.localDomain = localDomain.getValue();
            return this;
        }

        public Builder withLocalDomain(byte localDomain) {
            this.localDomain = localDomain;
            return this;
        }

        @Override
        public DceSecurityFactory build() {
            return new DceSecurityFactory(this);
        }
    }
}

