/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.nonstandard;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.AbstCombFactory;
import com.github.f4b6a3.uuid.factory.function.RandomFunction;
import com.github.f4b6a3.uuid.util.internal.ByteUtil;
import java.time.Clock;
import java.util.Random;
import java.util.UUID;

public final class ShortSuffixCombFactory
extends AbstCombFactory {
    protected final int interval;
    protected static final int DEFAULT_INTERVAL = 60000;

    public ShortSuffixCombFactory() {
        this(ShortSuffixCombFactory.builder());
    }

    public ShortSuffixCombFactory(Clock clock) {
        this(ShortSuffixCombFactory.builder().withClock(clock));
    }

    public ShortSuffixCombFactory(Random random) {
        this(ShortSuffixCombFactory.builder().withRandom(random));
    }

    public ShortSuffixCombFactory(Random random, Clock clock) {
        this(ShortSuffixCombFactory.builder().withRandom(random).withClock(clock));
    }

    public ShortSuffixCombFactory(RandomFunction randomFunction) {
        this(ShortSuffixCombFactory.builder().withRandomFunction(randomFunction));
    }

    public ShortSuffixCombFactory(RandomFunction randomFunction, Clock clock) {
        this(ShortSuffixCombFactory.builder().withRandomFunction(randomFunction).withClock(clock));
    }

    private ShortSuffixCombFactory(Builder builder) {
        super(UuidVersion.VERSION_RANDOM_BASED, builder);
        this.interval = builder.getInterval();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public UUID create() {
        byte[] bytes = (byte[])this.randomFunction.apply(14);
        long msb = ByteUtil.toNumber(bytes, 0, 8);
        long lsb = ByteUtil.toNumber(bytes, 8, 14);
        long timestamp = this.clock.millis() / (long)this.interval;
        lsb = (lsb & 0xFFFF00000000L) << 16 | lsb & 0xFFFFFFFFL | (timestamp & 0xFFFFL) << 32;
        return this.toUuid(msb, lsb);
    }

    public static class Builder
    extends AbstCombFactory.Builder<ShortSuffixCombFactory> {
        private Integer interval;

        protected int getInterval() {
            if (this.interval == null) {
                this.interval = 60000;
            }
            return this.interval;
        }

        public Builder withClock(Clock clock) {
            return (Builder)super.withClock(clock);
        }

        public Builder withRandom(Random random) {
            return (Builder)super.withRandom(random);
        }

        public Builder withRandomFunction(RandomFunction randomFunction) {
            return (Builder)super.withRandomFunction(randomFunction);
        }

        public Builder withInterval(int interval) {
            this.interval = interval;
            return this;
        }

        @Override
        public ShortSuffixCombFactory build() {
            return new ShortSuffixCombFactory(this);
        }
    }
}

