/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

import com.github.f4b6a3.uuid.UuidCreator;
import java.util.Comparator;
import java.util.UUID;
import java.util.function.ToIntBiFunction;

public final class UuidComparator
implements Comparator<UUID> {
    private final ToIntBiFunction<UUID, UUID> comparator;
    private static final UuidComparator INSTANCE_DEFAULT = new UuidComparator(UuidComparator::defaultCompare);
    private static final UuidComparator INSTANCE_OPAQUE = new UuidComparator(UuidComparator::opaqueCompare);

    private UuidComparator(ToIntBiFunction<UUID, UUID> comparator) {
        this.comparator = comparator;
    }

    public UuidComparator() {
        this(UuidComparator::defaultCompare);
    }

    public static UuidComparator getDefaultInstance() {
        return INSTANCE_DEFAULT;
    }

    public static UuidComparator getOpaqueInstance() {
        return INSTANCE_OPAQUE;
    }

    public static int defaultCompare(UUID uuid1, UUID uuid2) {
        UUID u2;
        UUID u1 = uuid1 != null ? uuid1 : UuidCreator.getNil();
        UUID uUID = u2 = uuid2 != null ? uuid2 : UuidCreator.getNil();
        if (UuidComparator.isTimeBased(u1) && UuidComparator.isTimeBased(u2)) {
            UUID rearranged1 = new UUID(u1.timestamp(), u1.getLeastSignificantBits());
            UUID rearranged2 = new UUID(u2.timestamp(), u2.getLeastSignificantBits());
            return UuidComparator.opaqueCompare(rearranged1, rearranged2);
        }
        return UuidComparator.opaqueCompare(u1, u2);
    }

    public static int opaqueCompare(UUID uuid1, UUID uuid2) {
        UUID u1 = uuid1 != null ? uuid1 : UuidCreator.getNil();
        UUID u2 = uuid2 != null ? uuid2 : UuidCreator.getNil();
        long mask = 0xFFFFFFFFL;
        long msb1 = u1.getMostSignificantBits();
        long lsb1 = u1.getLeastSignificantBits();
        long msb2 = u2.getMostSignificantBits();
        long lsb2 = u2.getLeastSignificantBits();
        long[] a = new long[]{msb1 >>> 32, msb1 & 0xFFFFFFFFL, lsb1 >>> 32, lsb1 & 0xFFFFFFFFL};
        long[] b = new long[]{msb2 >>> 32, msb2 & 0xFFFFFFFFL, lsb2 >>> 32, lsb2 & 0xFFFFFFFFL};
        for (int i = 0; i < a.length; ++i) {
            if (a[i] > b[i]) {
                return 1;
            }
            if (a[i] >= b[i]) continue;
            return -1;
        }
        return 0;
    }

    @Override
    public int compare(UUID uuid1, UUID uuid2) {
        return this.comparator.applyAsInt(uuid1, uuid2);
    }

    private static boolean isTimeBased(UUID uuid) {
        return uuid.version() == 1 && uuid.variant() == 2;
    }
}

