/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec.other;

import com.github.f4b6a3.uuid.codec.BinaryCodec;
import com.github.f4b6a3.uuid.codec.UuidCodec;
import com.github.f4b6a3.uuid.codec.base.Base32Codec;
import com.github.f4b6a3.uuid.codec.base.Base64UrlCodec;
import com.github.f4b6a3.uuid.codec.base.BaseNCodec;
import com.github.f4b6a3.uuid.util.immutable.CharArray;
import com.github.f4b6a3.uuid.util.immutable.LongArray;
import java.util.UUID;

public final class NcnameCodec
implements UuidCodec<String> {
    public static final NcnameCodec INSTANCE = new NcnameCodec();
    private final int radix;
    private final int length;
    private final int shift;
    private final char padding;
    private final BaseNCodec codec;
    private static final CharArray VERSION_UPPERCASE = CharArray.from("ABCDEFGHIJKLMNOP".toCharArray());
    private static final CharArray VERSION_LOWERCASE = CharArray.from("abcdefghijklmnop".toCharArray());
    private static final LongArray VERSION_MAP;

    public NcnameCodec() {
        this(Base64UrlCodec.INSTANCE);
    }

    public NcnameCodec(BaseNCodec codec) {
        if (!(codec instanceof Base64UrlCodec) && !(codec instanceof Base32Codec)) {
            throw new IllegalArgumentException("Unsupported base-n codec");
        }
        this.codec = codec;
        this.radix = codec.getBase().getRadix();
        this.length = codec.getBase().getLength();
        this.padding = codec.getBase().getPadding();
        switch (this.radix) {
            case 32: {
                this.shift = 1;
                break;
            }
            case 64: {
                this.shift = 2;
                break;
            }
            default: {
                this.shift = 0;
            }
        }
    }

    @Override
    public String encode(UUID uuid) {
        int version = uuid.version();
        byte[] bytes = BinaryCodec.INSTANCE.encode(uuid);
        int[] ints = NcnameCodec.toInts(bytes);
        int variant = (ints[2] & 0xF0000000) >>> 24;
        ints[1] = ints[1] & 0xFFFF0000 | (ints[1] & 0xFFF) << 4 | (ints[2] & 0xFFFFFFF) >>> 24;
        ints[2] = (ints[2] & 0xFFFFFF) << 8 | ints[3] >>> 24;
        ints[3] = ints[3] << 8 | variant;
        bytes = NcnameCodec.fromInts(ints);
        bytes[15] = (byte)((bytes[15] & 0xFF) >>> this.shift);
        UUID uuuu = BinaryCodec.INSTANCE.decode(bytes);
        String encoded = this.codec.encode(uuuu).substring(0, this.length - 1);
        char v = this.radix == 64 ? VERSION_UPPERCASE.get(version) : VERSION_LOWERCASE.get(version);
        return v + encoded;
    }

    @Override
    public UUID decode(String ncname) {
        int version = (int)VERSION_MAP.get(ncname.charAt(0));
        String substring = ncname.substring(1, ncname.length());
        UUID uuid = this.codec.decode(substring + this.padding);
        byte[] bytes = BinaryCodec.INSTANCE.encode(uuid);
        bytes[15] = (byte)((bytes[15] & 0xFF) << this.shift);
        version &= 0xF;
        int[] ints = NcnameCodec.toInts(bytes);
        int variant = (ints[3] & 0xF0) << 24;
        ints[3] = ints[3] >>> 8;
        ints[3] = ints[3] | (ints[2] & 0xFF) << 24;
        ints[2] = ints[2] >>> 8;
        ints[2] = ints[2] | ((ints[1] & 0xF) << 24 | variant);
        ints[1] = ints[1] & 0xFFFF0000 | version << 12 | ints[1] >>> 4 & 0xFFF;
        bytes = NcnameCodec.fromInts(ints);
        return BinaryCodec.INSTANCE.decode(bytes);
    }

    private static int[] toInts(byte[] bytes) {
        int[] ints = new int[4];
        ints[0] = ints[0] | (bytes[0] & 0xFF) << 24;
        ints[0] = ints[0] | (bytes[1] & 0xFF) << 16;
        ints[0] = ints[0] | (bytes[2] & 0xFF) << 8;
        ints[0] = ints[0] | bytes[3] & 0xFF;
        ints[1] = ints[1] | (bytes[4] & 0xFF) << 24;
        ints[1] = ints[1] | (bytes[5] & 0xFF) << 16;
        ints[1] = ints[1] | (bytes[6] & 0xFF) << 8;
        ints[1] = ints[1] | bytes[7] & 0xFF;
        ints[2] = ints[2] | (bytes[8] & 0xFF) << 24;
        ints[2] = ints[2] | (bytes[9] & 0xFF) << 16;
        ints[2] = ints[2] | (bytes[10] & 0xFF) << 8;
        ints[2] = ints[2] | bytes[11] & 0xFF;
        ints[3] = ints[3] | (bytes[12] & 0xFF) << 24;
        ints[3] = ints[3] | (bytes[13] & 0xFF) << 16;
        ints[3] = ints[3] | (bytes[14] & 0xFF) << 8;
        ints[3] = ints[3] | bytes[15] & 0xFF;
        return ints;
    }

    private static byte[] fromInts(int[] ints) {
        byte[] bytes = new byte[]{(byte)(ints[0] >>> 24), (byte)(ints[0] >>> 16), (byte)(ints[0] >>> 8), (byte)ints[0], (byte)(ints[1] >>> 24), (byte)(ints[1] >>> 16), (byte)(ints[1] >>> 8), (byte)ints[1], (byte)(ints[2] >>> 24), (byte)(ints[2] >>> 16), (byte)(ints[2] >>> 8), (byte)ints[2], (byte)(ints[3] >>> 24), (byte)(ints[3] >>> 16), (byte)(ints[3] >>> 8), (byte)ints[3]};
        return bytes;
    }

    static {
        long[] mapping = new long[128];
        for (int i = 0; i < mapping.length; ++i) {
            mapping[i] = -1L;
        }
        mapping[65] = 0L;
        mapping[66] = 1L;
        mapping[67] = 2L;
        mapping[68] = 3L;
        mapping[69] = 4L;
        mapping[70] = 5L;
        mapping[71] = 6L;
        mapping[72] = 7L;
        mapping[73] = 8L;
        mapping[74] = 9L;
        mapping[75] = 10L;
        mapping[76] = 11L;
        mapping[77] = 12L;
        mapping[78] = 13L;
        mapping[79] = 14L;
        mapping[80] = 15L;
        mapping[97] = 0L;
        mapping[98] = 1L;
        mapping[99] = 2L;
        mapping[100] = 3L;
        mapping[101] = 4L;
        mapping[102] = 5L;
        mapping[103] = 6L;
        mapping[104] = 7L;
        mapping[105] = 8L;
        mapping[106] = 9L;
        mapping[107] = 10L;
        mapping[108] = 11L;
        mapping[109] = 12L;
        mapping[110] = 13L;
        mapping[111] = 14L;
        mapping[112] = 15L;
        VERSION_MAP = LongArray.from(mapping);
    }
}

