/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec.base;

import com.github.f4b6a3.uuid.codec.UuidCodec;
import com.github.f4b6a3.uuid.codec.base.BaseN;
import com.github.f4b6a3.uuid.codec.base.function.BaseNDecoder;
import com.github.f4b6a3.uuid.codec.base.function.BaseNEncoder;
import com.github.f4b6a3.uuid.codec.base.function.BaseNRemainderDecoder;
import com.github.f4b6a3.uuid.codec.base.function.BaseNRemainderEncoder;
import java.util.UUID;
import java.util.function.Function;

public abstract class BaseNCodec
implements UuidCodec<String> {
    protected final BaseN base;
    protected final Function<UUID, String> encoder;
    protected final Function<String, UUID> decoder;

    protected BaseNCodec(BaseN base) {
        this(base, new BaseNRemainderEncoder(base), new BaseNRemainderDecoder(base));
    }

    protected BaseNCodec(BaseN base, BaseNEncoder encoder, BaseNDecoder decoder) {
        this.base = base;
        this.encoder = encoder;
        this.decoder = decoder;
    }

    public static BaseNCodec newInstance(BaseN base) {
        return new BaseNCodec(base){};
    }

    public static BaseNCodec newInstance(int radix) {
        BaseN base = new BaseN(radix);
        return BaseNCodec.newInstance(base);
    }

    public static BaseNCodec newInstance(String alphabet) {
        BaseN base = new BaseN(alphabet);
        return BaseNCodec.newInstance(base);
    }

    @Override
    public String encode(UUID uuid) {
        return this.encoder.apply(uuid);
    }

    @Override
    public UUID decode(String string) {
        return this.decoder.apply(string);
    }

    public BaseN getBase() {
        return this.base;
    }
}

