/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

import com.github.f4b6a3.uuid.codec.base.BaseN;
import com.github.f4b6a3.uuid.exception.InvalidUuidException;
import com.github.f4b6a3.uuid.util.immutable.LongArray;

public final class UuidValidator {
    private static final LongArray MAP = BaseN.BASE_16.getMap();

    private UuidValidator() {
    }

    public static boolean isValid(byte[] uuid) {
        return uuid != null && uuid.length == 16;
    }

    public static boolean isValid(byte[] uuid, int version) {
        return uuid != null && uuid.length == 16 && UuidValidator.isVersion(uuid, version);
    }

    public static void validate(byte[] uuid) {
        if (uuid == null || uuid.length != 16) {
            throw new InvalidUuidException("Invalid UUID byte array.");
        }
    }

    public static void validate(byte[] uuid, int version) {
        if (uuid == null || uuid.length != 16 || !UuidValidator.isVersion(uuid, version)) {
            throw new InvalidUuidException("Invalid UUID byte array.");
        }
    }

    public static boolean isValid(String uuid) {
        return uuid != null && uuid.length() != 0 && UuidValidator.isUuidString(uuid.toCharArray());
    }

    public static boolean isValid(String uuid, int version) {
        return uuid != null && uuid.length() != 0 && UuidValidator.isUuidString(uuid.toCharArray(), version);
    }

    public static boolean isValid(char[] uuid) {
        return uuid != null && uuid.length != 0 && UuidValidator.isUuidString(uuid);
    }

    public static boolean isValid(char[] uuid, int version) {
        return uuid != null && uuid.length != 0 && UuidValidator.isUuidString(uuid, version);
    }

    public static void validate(String uuid) {
        if (uuid == null || !UuidValidator.isUuidString(uuid.toCharArray())) {
            UuidValidator.throwInvalidUuidException(uuid);
        }
    }

    public static void validate(String uuid, int version) {
        if (uuid == null || !UuidValidator.isUuidString(uuid.toCharArray(), version)) {
            UuidValidator.throwInvalidUuidException(uuid);
        }
    }

    public static void validate(char[] uuid) {
        if (uuid == null || !UuidValidator.isUuidString(uuid)) {
            UuidValidator.throwInvalidUuidException(uuid);
        }
    }

    public static void validate(char[] uuid, int version) {
        if (uuid == null || !UuidValidator.isUuidString(uuid, version)) {
            UuidValidator.throwInvalidUuidException(uuid);
        }
    }

    protected static boolean isUuidString(char[] chars) {
        int hyphens = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (MAP.get(chars[i]) != -1L) continue;
            if (chars[i] == '-') {
                ++hyphens;
                continue;
            }
            return false;
        }
        if (chars.length == 36 && hyphens == 4) {
            return chars[8] == '-' && chars[13] == '-' && chars[18] == '-' && chars[23] == '-';
        }
        return chars.length == 32 && hyphens == 0;
    }

    protected static boolean isUuidString(char[] chars, int version) {
        return UuidValidator.isVersion(chars, version) && UuidValidator.isUuidString(chars);
    }

    protected static boolean isVersion(byte[] bytes, int version) {
        boolean versionOk = (version & 0xFFFFFFF0) == 0 && (bytes[6] & 0xFF) >>> 4 == version;
        boolean variantOk = (bytes[8] & 0xFF) >>> 6 == 2;
        return versionOk && variantOk;
    }

    protected static boolean isVersion(char[] chars, int version) {
        if ((version & 0xFFFFFFF0) != 0) {
            return false;
        }
        int ver = 0;
        int var = 0;
        switch (chars.length) {
            case 32: {
                ver = 12;
                var = 16;
                break;
            }
            case 36: {
                ver = 14;
                var = 19;
                break;
            }
            default: {
                return false;
            }
        }
        char[] lower = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] upper = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        boolean versionOk = (version & 0xFFFFFFF0) == 0 && (chars[ver] == lower[version] || chars[ver] == upper[version]);
        boolean variantOk = chars[var] == '8' || chars[var] == '9' || chars[var] == 'a' || chars[var] == 'b' || chars[var] == 'A' || chars[var] == 'B';
        return versionOk && variantOk;
    }

    private static void throwInvalidUuidException(char[] chars) {
        String string = chars == null ? null : new String(chars);
        throw new InvalidUuidException("Invalid UUID: \"" + string + "\"");
    }

    private static void throwInvalidUuidException(String string) {
        throw new InvalidUuidException("Invalid UUID: \"" + string + "\"");
    }
}

