/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.function;

import com.github.f4b6a3.uuid.util.internal.RandomUtil;
import java.util.function.LongUnaryOperator;

@FunctionalInterface
public interface ClockSeqFunction
extends LongUnaryOperator {
    public static long getRandom() {
        long nodeIdentifier = RandomUtil.nextLong();
        return ClockSeqFunction.toExpectedRange(nodeIdentifier);
    }

    public static long toExpectedRange(long clockseq) {
        return clockseq & 0x3FFFL;
    }

    public static final class ClockSeqPool {
        private final byte[] pool = new byte[2048];
        private static final int POOL_SIZE = 16384;
        public static final int POOL_MIN = 0;
        public static final int POOL_MAX = 16383;

        public synchronized int take(int take) {
            for (int i = 0; i < 16384; ++i) {
                if (this.setBit(take)) {
                    return take;
                }
                ++take;
                take %= 16384;
            }
            this.clearPool();
            this.setBit(take);
            return take;
        }

        public synchronized int random() {
            int random = (RandomUtil.nextInt() & Integer.MAX_VALUE) % 16384;
            return this.take(random);
        }

        private synchronized boolean setBit(int value) {
            boolean clear;
            if (value < 0) {
                return false;
            }
            int byteIndex = value / 8;
            int bitIndex = value % 8;
            int mask = 1 << bitIndex;
            boolean bl = clear = (this.pool[byteIndex] & mask) == 0;
            if (clear) {
                this.pool[byteIndex] = (byte)(this.pool[byteIndex] | mask);
                return true;
            }
            return false;
        }

        public synchronized boolean isUsed(int value) {
            int byteIndex = value / 8;
            int bitIndex = value % 8;
            int mask = 1 << bitIndex;
            boolean clear = (this.pool[byteIndex] & mask) == 0;
            return !clear;
        }

        public synchronized boolean isFree(int value) {
            return !this.isUsed(value);
        }

        public synchronized int countUsed() {
            int counter = 0;
            for (int i = 0; i < 16384; ++i) {
                if (!this.isUsed(i)) continue;
                ++counter;
            }
            return counter;
        }

        public synchronized int countFree() {
            return 16384 - this.countUsed();
        }

        public synchronized void clearPool() {
            for (int i = 0; i < this.pool.length; ++i) {
                this.pool[i] = 0;
            }
        }
    }
}

