/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.nonstandard;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.AbstRandomBasedFactory;
import com.github.f4b6a3.uuid.factory.function.RandomFunction;
import com.github.f4b6a3.uuid.factory.function.impl.DefaultRandomFunction;
import com.github.f4b6a3.uuid.util.internal.ByteUtil;
import java.util.Random;
import java.util.UUID;

public final class ShortPrefixCombFactory
extends AbstRandomBasedFactory {
    protected static final int ONE_MINUTE = 60000;

    public ShortPrefixCombFactory() {
        this(new DefaultRandomFunction());
    }

    public ShortPrefixCombFactory(Random random) {
        this(ShortPrefixCombFactory.getRandomFunction(random));
    }

    public ShortPrefixCombFactory(RandomFunction randomFunction) {
        super(UuidVersion.VERSION_RANDOM_BASED, randomFunction);
    }

    @Override
    public UUID create() {
        byte[] bytes = (byte[])this.randomFunction.apply(14);
        long msb = ByteUtil.toNumber(bytes, 8, 14);
        long lsb = ByteUtil.toNumber(bytes, 0, 8);
        long timestamp = System.currentTimeMillis() / 60000L;
        return this.getUuid(msb |= (timestamp & 0xFFFFL) << 48, lsb);
    }
}

