/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory;

import com.github.f4b6a3.uuid.codec.BinaryCodec;
import com.github.f4b6a3.uuid.codec.StringCodec;
import com.github.f4b6a3.uuid.enums.UuidNamespace;
import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.exception.InvalidUuidException;
import com.github.f4b6a3.uuid.factory.UuidFactory;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

public abstract class AbstNameBasedFactory
extends UuidFactory {
    protected byte[] namespace = null;
    protected final String algorithm;
    protected static final String ALGORITHM_MD5 = "MD5";
    protected static final String ALGORITHM_SHA1 = "SHA-1";

    public AbstNameBasedFactory(UuidVersion version, String algorithm, byte[] namespace) {
        super(version);
        if (namespace != null && namespace.length != 16) {
            throw new InvalidUuidException("Invalid namespace length");
        }
        this.algorithm = algorithm;
        this.namespace = namespace;
    }

    public UUID create(byte[] name) {
        return this.create(this.namespace, name);
    }

    public UUID create(String name) {
        byte[] n = name.getBytes(StandardCharsets.UTF_8);
        return this.create(this.namespace, n);
    }

    public UUID create(UUID name) {
        return this.create(this.namespace, BinaryCodec.INSTANCE.encode(name));
    }

    public UUID create(UUID namespace, byte[] name) {
        byte[] ns = namespace == null ? null : BinaryCodec.INSTANCE.encode(namespace);
        return this.create(ns, name);
    }

    public UUID create(UUID namespace, String name) {
        byte[] ns = namespace == null ? null : BinaryCodec.INSTANCE.encode(namespace);
        byte[] n = name.getBytes(StandardCharsets.UTF_8);
        return this.create(ns, n);
    }

    public UUID create(UUID namespace, UUID name) {
        byte[] ns = namespace == null ? null : BinaryCodec.INSTANCE.encode(namespace);
        byte[] n = BinaryCodec.INSTANCE.encode(name);
        return this.create(ns, n);
    }

    public UUID create(String namespace, byte[] name) {
        byte[] ns = namespace == null ? null : BinaryCodec.INSTANCE.encode(StringCodec.INSTANCE.decode(namespace));
        return this.create(ns, name);
    }

    public UUID create(String namespace, String name) {
        byte[] ns = namespace == null ? null : BinaryCodec.INSTANCE.encode(StringCodec.INSTANCE.decode(namespace));
        byte[] n = name.getBytes(StandardCharsets.UTF_8);
        return this.create(ns, n);
    }

    public UUID create(String namespace, UUID name) {
        byte[] ns = namespace == null ? null : BinaryCodec.INSTANCE.encode(StringCodec.INSTANCE.decode(namespace));
        byte[] n = BinaryCodec.INSTANCE.encode(name);
        return this.create(ns, n);
    }

    public UUID create(UuidNamespace namespace, byte[] name) {
        byte[] ns = namespace == null ? null : BinaryCodec.INSTANCE.encode(namespace.getValue());
        return this.create(ns, name);
    }

    public UUID create(UuidNamespace namespace, String name) {
        byte[] ns = namespace == null ? null : BinaryCodec.INSTANCE.encode(namespace.getValue());
        byte[] n = name.getBytes(StandardCharsets.UTF_8);
        return this.create(ns, n);
    }

    public UUID create(UuidNamespace namespace, UUID name) {
        byte[] ns = namespace == null ? null : BinaryCodec.INSTANCE.encode(namespace.getValue());
        byte[] n = BinaryCodec.INSTANCE.encode(name);
        return this.create(ns, n);
    }

    private UUID create(byte[] namespace, byte[] name) {
        MessageDigest hasher;
        try {
            hasher = MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Message digest algorithm not available: " + this.algorithm, e);
        }
        if (namespace != null) {
            hasher.update(namespace);
        }
        byte[] hash = hasher.digest(name);
        return this.getUuid(hash);
    }
}

