/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec.slug;

import com.github.f4b6a3.uuid.codec.UuidCodec;
import com.github.f4b6a3.uuid.codec.base.Base64UrlCodec;
import com.github.f4b6a3.uuid.codec.base.BaseNCodec;
import java.util.UUID;

public final class SlugCodec
implements UuidCodec<String> {
    public static final SlugCodec INSTANCE = new SlugCodec();
    private final BaseNCodec codec;

    public SlugCodec() {
        this(Base64UrlCodec.INSTANCE);
    }

    public SlugCodec(BaseNCodec codec) {
        if (codec == null) {
            throw new IllegalArgumentException("Null codec");
        }
        this.codec = codec;
    }

    @Override
    public String encode(UUID uuid) {
        long long1 = uuid.getMostSignificantBits();
        long long2 = uuid.getLeastSignificantBits();
        long msb = 0L;
        long lsb = 0L;
        msb |= (long1 & 0xF000L) << 48;
        msb |= (long2 & 0xF000000000000000L) >>> 4;
        msb |= (long1 & 0xFFFFFFFFFFFF0000L) >>> 8;
        lsb |= (long1 & 0xFL) << 60;
        return this.codec.encode(new UUID(msb |= (long1 & 0xFFFL) >>> 4, lsb |= long2 & 0xFFFFFFFFFFFFFFFL));
    }

    @Override
    public UUID decode(String string) {
        UUID uuid = this.codec.decode(string);
        long long1 = uuid.getMostSignificantBits();
        long long2 = uuid.getLeastSignificantBits();
        long msb = 0L;
        long lsb = 0L;
        msb |= (long1 & 0xF000000000000000L) >>> 48;
        msb |= (long2 & 0xF000000000000000L) >>> 60;
        msb |= (long1 & 0xFFFFFFFFFFFF00L) << 8;
        lsb |= (long1 & 0xF00000000000000L) << 4;
        return new UUID(msb |= (long1 & 0xFFL) << 4, lsb |= long2 & 0xFFFFFFFFFFFFFFFL);
    }
}

