/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec.base.function;

import com.github.f4b6a3.uuid.codec.base.BaseN;
import com.github.f4b6a3.uuid.exception.UuidCodecException;
import java.util.UUID;
import java.util.function.Function;

public abstract class BaseNDecoder
implements Function<String, UUID> {
    protected final BaseN base;
    protected final char[][] alphabets = new char[2][];
    protected final long[] map = new long[128];

    public BaseNDecoder(BaseN base, String alphabet) {
        int i;
        this.base = base;
        if (base.isInsensitive()) {
            this.alphabets[0] = alphabet.toLowerCase().toCharArray();
            this.alphabets[1] = alphabet.toUpperCase().toCharArray();
        } else {
            this.alphabets[0] = alphabet.toCharArray();
            this.alphabets[1] = alphabet.toCharArray();
        }
        for (i = 0; i < this.map.length; ++i) {
            this.map[i] = -1L;
        }
        for (i = 0; i < this.alphabets[0].length; ++i) {
            this.map[this.alphabets[0][i]] = i;
            this.map[this.alphabets[1][i]] = i;
        }
    }

    protected char[] toCharArray(String string) {
        char[] chars = string == null ? null : string.toCharArray();
        this.validate(chars);
        return chars;
    }

    private void validate(char[] chars) {
        if (chars == null || chars.length != this.base.getLength()) {
            throw new UuidCodecException("Invalid string: \"" + (chars == null ? null : new String(chars)) + "\"");
        }
        for (int i = 0; i < chars.length; ++i) {
            boolean found = false;
            for (int j = 0; j < this.alphabets[0].length; ++j) {
                if (chars[i] != this.alphabets[0][j] && chars[i] != this.alphabets[1][j]) continue;
                found = true;
            }
            if (found) continue;
            throw new UuidCodecException("Invalid string: \"" + new String(chars) + "\"");
        }
    }
}

