/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec.uuid;

import com.github.f4b6a3.uuid.codec.UuidCodec;
import com.github.f4b6a3.uuid.util.UuidUtil;
import java.util.UUID;

public class TimeOrderedCodec
implements UuidCodec<UUID> {
    @Override
    public UUID encode(UUID uuid) {
        if (!UuidUtil.isTimeBased(uuid)) {
            throw new IllegalArgumentException(String.format("Not a time-based UUID: %s.", uuid.toString()));
        }
        long timestamp = UuidUtil.extractTimestamp(uuid);
        long msb = (timestamp & 0xFFFFFFFFFFFF000L) << 4 | timestamp & 0xFFFL | 0x6000L;
        long lsb = uuid.getLeastSignificantBits();
        return new UUID(msb, lsb);
    }

    @Override
    public UUID decode(UUID uuid) {
        if (!UuidUtil.isTimeOrdered(uuid)) {
            throw new IllegalArgumentException(String.format("Not a time-ordered UUID: %s.", uuid.toString()));
        }
        long timestamp = UuidUtil.extractTimestamp(uuid);
        long msb = (timestamp & 0xFFF000000000000L) >>> 48 | (timestamp & 0xFFFF00000000L) >>> 16 | (timestamp & 0xFFFFFFFFL) << 32 | 0x1000L;
        long lsb = uuid.getLeastSignificantBits();
        return new UUID(msb, lsb);
    }
}

