/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.creator;

import com.github.f4b6a3.uuid.creator.AbstractUuidCreator;
import com.github.f4b6a3.uuid.enums.UuidNamespace;
import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.util.UuidConverter;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

public abstract class AbstractNameBasedUuidCreator
extends AbstractUuidCreator {
    protected byte[] namespace = null;
    protected final String algorithm;
    protected static final String ALGORITHM_MD5 = "MD5";
    protected static final String ALGORITHM_SHA1 = "SHA-1";

    public AbstractNameBasedUuidCreator(UuidVersion version, String algorithm) {
        super(version);
        this.algorithm = algorithm;
    }

    public UUID create(byte[] name) {
        return this.create(this.namespace, name);
    }

    public UUID create(String name) {
        byte[] n = name.getBytes(StandardCharsets.UTF_8);
        return this.create(this.namespace, n);
    }

    public UUID create(UUID namespace, byte[] name) {
        byte[] ns = namespace == null ? null : UuidConverter.toBytes(namespace);
        return this.create(ns, name);
    }

    public UUID create(UUID namespace, String name) {
        byte[] ns = namespace == null ? null : UuidConverter.toBytes(namespace);
        byte[] n = name.getBytes(StandardCharsets.UTF_8);
        return this.create(ns, n);
    }

    public UUID create(String namespace, byte[] name) {
        byte[] ns = namespace == null ? null : UuidConverter.toBytes(UuidConverter.fromString(namespace));
        return this.create(ns, name);
    }

    public UUID create(String namespace, String name) {
        byte[] ns = namespace == null ? null : UuidConverter.toBytes(UuidConverter.fromString(namespace));
        byte[] n = name.getBytes(StandardCharsets.UTF_8);
        return this.create(ns, n);
    }

    public UUID create(UuidNamespace namespace, byte[] name) {
        byte[] ns = namespace == null ? null : UuidConverter.toBytes(namespace.getValue());
        return this.create(ns, name);
    }

    public UUID create(UuidNamespace namespace, String name) {
        byte[] ns = namespace == null ? null : UuidConverter.toBytes(namespace.getValue());
        byte[] n = name.getBytes(StandardCharsets.UTF_8);
        return this.create(ns, n);
    }

    private UUID create(byte[] namespace, byte[] name) {
        MessageDigest hasher;
        byte[] hash = null;
        try {
            hasher = MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Message digest algorithm not available: " + this.algorithm, e);
        }
        if (namespace != null) {
            hasher.update(namespace);
        }
        hash = hasher.digest(name);
        return this.getUuid(hash);
    }

    public synchronized <T extends AbstractNameBasedUuidCreator> T withNamespace(UUID namespace) {
        this.namespace = UuidConverter.toBytes(namespace);
        return (T)this;
    }

    public synchronized <T extends AbstractNameBasedUuidCreator> T withNamespace(String namespace) {
        this.namespace = UuidConverter.toBytes(UuidConverter.fromString(namespace));
        return (T)this;
    }

    public synchronized <T extends AbstractNameBasedUuidCreator> T withNamespace(UuidNamespace namespace) {
        this.namespace = UuidConverter.toBytes(namespace.getValue());
        return (T)this;
    }
}

