/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

public final class UuidCreatorSettings {
    protected static final String PROPERTY_PREFIX = "uuidcreator";
    public static final String PROPERTY_NODE = "node";

    protected UuidCreatorSettings() {
    }

    public static Long getNodeIdentifier() {
        String value = UuidCreatorSettings.getProperty(PROPERTY_NODE);
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            return Long.decode(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static void setNodeIdentifier(Long nodeid) {
        String value = Long.toString(nodeid);
        UuidCreatorSettings.setProperty(PROPERTY_NODE, value);
    }

    public static String getProperty(String name) {
        String fullName = UuidCreatorSettings.getPropertyName(name);
        String value = System.getProperty(fullName);
        if (!UuidCreatorSettings.isEmpty(value)) {
            return value;
        }
        fullName = UuidCreatorSettings.getEnvinronmentName(name);
        value = System.getenv(fullName);
        if (!UuidCreatorSettings.isEmpty(value)) {
            return value;
        }
        return null;
    }

    public static void setProperty(String key, String value) {
        System.setProperty(UuidCreatorSettings.getPropertyName(key), value);
    }

    public static void clearProperty(String key) {
        System.clearProperty(UuidCreatorSettings.getPropertyName(key));
    }

    protected static String getPropertyName(String key) {
        return String.join((CharSequence)".", PROPERTY_PREFIX, key);
    }

    protected static String getEnvinronmentName(String key) {
        return String.join((CharSequence)"_", PROPERTY_PREFIX, key).toUpperCase().replace(".", "_");
    }

    private static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }
}

