/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.strategy.timestamp;

import com.github.f4b6a3.uuid.exception.UuidCreatorException;
import com.github.f4b6a3.uuid.strategy.TimestampStrategy;
import com.github.f4b6a3.uuid.util.TlsSecureRandom;
import com.github.f4b6a3.uuid.util.UuidTime;
import java.util.concurrent.atomic.AtomicInteger;

public final class DefaultTimestampStrategy
implements TimestampStrategy {
    private AtomicInteger counter;
    private long previousTimestamp = 0L;
    protected static final int COUNTER_MIN = 0;
    protected static final int COUNTER_MAX = 9999;
    private static final int COUNTER_INITIAL_MASK = 255;
    private static final String OVERRUN_MESSAGE = "The system overran the generator by requesting too many UUIDs.";

    public DefaultTimestampStrategy() {
        int initial = TlsSecureRandom.get().nextInt() & 0xFF;
        this.counter = new AtomicInteger(initial);
    }

    @Override
    public long getTimestamp() {
        long timestamp = UuidTime.getCurrentTimestamp();
        long count = this.getNextCounter(timestamp);
        return timestamp + count;
    }

    protected long getNextCounter(long timestamp) {
        if (timestamp == this.previousTimestamp) {
            this.previousTimestamp = timestamp;
            return this.next();
        }
        this.previousTimestamp = timestamp;
        return this.reset();
    }

    private int next() {
        if (this.counter.incrementAndGet() > 9999) {
            this.counter.set(0);
            throw new UuidCreatorException(OVERRUN_MESSAGE);
        }
        return this.counter.get();
    }

    private int reset() {
        return this.counter.updateAndGet(x -> x & 0xFF);
    }
}

