/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.strategy.timestamp;

import com.github.f4b6a3.uuid.exception.UuidCreatorException;
import com.github.f4b6a3.uuid.strategy.TimestampStrategy;
import com.github.f4b6a3.uuid.util.TlsSecureRandom;
import com.github.f4b6a3.uuid.util.UuidTimeUtil;
import com.github.f4b6a3.uuid.util.sequence.AbstractSequence;

public final class DefaultTimestampStrategy
implements TimestampStrategy {
    private long previousTimestamp = 0L;
    private final TimestampCounter timestampCounter = new TimestampCounter();

    @Override
    public long getTimestamp() {
        long timestamp = UuidTimeUtil.getCurrentTimestamp();
        long counter = this.getNextCounter(timestamp);
        return timestamp + counter;
    }

    protected long getNextCounter(long timestamp) {
        if (timestamp == this.previousTimestamp) {
            this.previousTimestamp = timestamp;
            return this.timestampCounter.next();
        }
        this.previousTimestamp = timestamp;
        return this.timestampCounter.reset();
    }

    protected class TimestampCounter
    extends AbstractSequence {
        protected static final int COUNTER_MIN = 0;
        protected static final int COUNTER_MAX = 9999;
        private static final int COUNTER_INITIAL_MASK = 255;
        private static final String OVERRUN_MESSAGE = "The system overran the generator by requesting too many UUIDs.";

        protected TimestampCounter() {
            super(0, 9999);
            this.value = TlsSecureRandom.get().nextInt() & 0xFF;
        }

        @Override
        public int next() {
            if (this.value >= this.maxValue) {
                this.value = this.minValue;
                throw new UuidCreatorException(OVERRUN_MESSAGE);
            }
            return ++this.value;
        }

        @Override
        public int reset() {
            this.value &= 0xFF;
            return this.value;
        }
    }
}

