/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.creator;

import com.github.f4b6a3.uuid.enums.UuidVersion;

public abstract class AbstractUuidCreator {
    protected final int version;
    protected final long versionBits;

    protected AbstractUuidCreator() {
        this.version = 0;
        this.versionBits = 0L;
    }

    public AbstractUuidCreator(int version) {
        if (version < 0 || version > 15) {
            throw new IllegalArgumentException("Invalid UUID version");
        }
        this.version = version;
        this.versionBits = version << 12;
    }

    public AbstractUuidCreator(UuidVersion version) {
        this(version.getValue());
    }

    public int getVersion() {
        return this.version;
    }

    protected long applyVersionBits(long msb) {
        return msb & 0xFFFFFFFFFFFF0FFFL | this.versionBits;
    }

    protected long applyVariantBits(long lsb) {
        return lsb & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
    }
}

