/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory;

import com.github.f4b6a3.uuid.exception.UuidCreatorException;
import com.github.f4b6a3.uuid.factory.abst.NoArgumentsUuidCreator;
import com.github.f4b6a3.uuid.random.Xorshift128PlusRandom;
import com.github.f4b6a3.uuid.timestamp.TimestampStrategy;
import com.github.f4b6a3.uuid.timestamp.UnixMillisecondsTimestampStretegy;
import com.github.f4b6a3.uuid.util.FingerprintUtil;
import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;

public class UlidBasedGuidCreator
implements NoArgumentsUuidCreator {
    protected long low;
    protected long high;
    protected long firstLow;
    protected long firstHigh;
    protected long previousTimestamp;
    protected Random random;
    protected static final long MASK_UNSIGNED_SHORT = 65535L;
    protected static final String OVERRUN_MESSAGE = "The system overran the generator by requesting too many GUIDs.";
    protected TimestampStrategy timestampStrategy;

    public UlidBasedGuidCreator() {
        this.reset();
        this.timestampStrategy = new UnixMillisecondsTimestampStretegy();
    }

    @Override
    public synchronized UUID create() {
        long timestamp = this.getTimestamp();
        long msb = timestamp << 16 | this.high;
        long lsb = this.low;
        return new UUID(msb, lsb);
    }

    protected synchronized long getTimestamp() {
        long timestamp = this.timestampStrategy.getTimestamp();
        if (timestamp == this.previousTimestamp) {
            this.increment();
        } else {
            this.reset();
        }
        this.previousTimestamp = timestamp;
        return timestamp;
    }

    protected synchronized void reset() {
        if (this.random == null) {
            this.low = SecureRandomLazyHolder.INSTANCE.nextLong();
            this.high = (long)SecureRandomLazyHolder.INSTANCE.nextInt() & 0xFFFFL;
        } else {
            this.low = this.random.nextLong();
            this.high = (long)this.random.nextInt() & 0xFFFFL;
        }
        this.firstLow = this.low;
        this.firstHigh = this.high;
    }

    protected synchronized void increment() {
        if (++this.low == this.firstLow && ++this.high == this.firstHigh) {
            this.reset();
            throw new UuidCreatorException(OVERRUN_MESSAGE);
        }
    }

    public synchronized <T extends UlidBasedGuidCreator> T withTimestampStrategy(TimestampStrategy timestampStrategy) {
        this.timestampStrategy = timestampStrategy;
        return (T)this;
    }

    public synchronized <T extends UlidBasedGuidCreator> T withRandomGenerator(Random random) {
        this.random = random;
        return (T)this;
    }

    public synchronized <T extends UlidBasedGuidCreator> T withFastRandomGenerator() {
        int salt = (int)FingerprintUtil.getFingerprint();
        this.random = new Xorshift128PlusRandom(salt);
        return (T)this;
    }

    private static class SecureRandomLazyHolder {
        static final Random INSTANCE = new SecureRandom();

        private SecureRandomLazyHolder() {
        }
    }
}

