/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.exception.UuidCreatorException;
import com.github.f4b6a3.uuid.factory.TimeBasedUuidCreator;
import com.github.f4b6a3.uuid.sequence.AbstractSequence;
import java.util.UUID;

public class DceSecurityUuidCreator
extends TimeBasedUuidCreator {
    public static final byte LOCAL_DOMAIN_PERSON = 0;
    public static final byte LOCAL_DOMAIN_GROUP = 1;
    public static final byte LOCAL_DOMAIN_ORG = 2;
    protected DCESTimestampCounter timestampCounter = new DCESTimestampCounter();
    protected byte localDomain;

    public DceSecurityUuidCreator() {
        super(UuidVersion.DCE_SECURITY);
        this.withoutOverrunException();
    }

    @Override
    public synchronized UUID create() {
        throw new UuidCreatorException("Not implemented.");
    }

    public synchronized UUID create(byte localDomain, int localIdentifier) {
        UUID uuid = super.create();
        long msb = DceSecurityUuidCreator.setLocalIdentifierBits(uuid.getMostSignificantBits(), localIdentifier);
        long counter = this.timestampCounter.next();
        long lsb = DceSecurityUuidCreator.setLocalDomainBits(uuid.getLeastSignificantBits(), localDomain, counter);
        return new UUID(this.setVersionBits(msb), this.setVariantBits(lsb));
    }

    public synchronized UUID create(int localIdentifier) {
        return this.create((byte)0, localIdentifier);
    }

    protected static long setLocalIdentifierBits(long msb, int localIdentifier) {
        return msb & 0xFFFFFFFFL | (long)localIdentifier << 32;
    }

    protected static long setLocalDomainBits(long lsb, byte localDomain, long counter) {
        return lsb & 0xFF00FFFFFFFFFFFFL | (long)localDomain << 48 | counter << 56;
    }

    public synchronized DceSecurityUuidCreator withLocalDomain(byte localDomain) {
        this.localDomain = localDomain;
        return this;
    }

    protected class DCESTimestampCounter
    extends AbstractSequence {
        private static final long COUNTER_MIN = 0L;
        private static final long COUNTER_MAX = 63L;

        protected DCESTimestampCounter() {
            super(0L, 63L);
        }
    }
}

