/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.abst;

import com.github.f4b6a3.uuid.enums.UuidNamespace;
import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.abst.AbstractUuidCreator;
import com.github.f4b6a3.uuid.util.ByteUtil;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

public abstract class AbstractNameBasedUuidCreator
extends AbstractUuidCreator {
    private UUID namespace;
    private MessageDigest md = null;
    protected static final String MESSAGE_DIGEST_MD5 = "MD5";
    protected static final String MESSAGE_DIGEST_SHA1 = "SHA-1";

    public AbstractNameBasedUuidCreator(UuidVersion version, String messageDigest) {
        super(version);
        try {
            this.md = MessageDigest.getInstance(messageDigest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("Message digest algorithm not supported.", e);
        }
    }

    public synchronized <T extends AbstractNameBasedUuidCreator> T withNamespace(UuidNamespace namespace) {
        this.namespace = namespace.getValue();
        return (T)this;
    }

    public synchronized <T extends AbstractNameBasedUuidCreator> T withNamespace(UUID namespace) {
        this.namespace = namespace;
        return (T)this;
    }

    public synchronized <T extends AbstractNameBasedUuidCreator> T withNamespace(String namespace) {
        this.namespace = this.create(namespace);
        return (T)this;
    }

    public UUID create(String name) {
        return this.create((UUID)null, name.getBytes(StandardCharsets.UTF_8));
    }

    public UUID create(byte[] name) {
        return this.create((UUID)null, name);
    }

    public UUID create(String namespace, String name) {
        UUID namespaceUUID = this.create(namespace);
        return this.create(namespaceUUID, name.getBytes(StandardCharsets.UTF_8));
    }

    public UUID create(String namespace, byte[] name) {
        UUID namespaceUUID = this.create(namespace);
        return this.create(namespaceUUID, name);
    }

    public UUID create(UUID namespace, String name) {
        return this.create(namespace, name.getBytes(StandardCharsets.UTF_8));
    }

    public UUID create(UuidNamespace namespace, String name) {
        return this.create(namespace.getValue(), name.getBytes(StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID create(UUID namespace, byte[] name) {
        byte[] hash;
        MessageDigest messageDigest = this.md;
        synchronized (messageDigest) {
            this.md.reset();
            if (namespace != null) {
                this.md.update(ByteUtil.toBytes(namespace.getMostSignificantBits()));
                this.md.update(ByteUtil.toBytes(namespace.getLeastSignificantBits()));
            } else if (this.namespace != null) {
                this.md.update(ByteUtil.toBytes(this.namespace.getMostSignificantBits()));
                this.md.update(ByteUtil.toBytes(this.namespace.getLeastSignificantBits()));
            }
            hash = this.md.digest(name);
        }
        long msb = ByteUtil.toNumber(hash, 0, 8);
        long lsb = ByteUtil.toNumber(hash, 8, 16);
        msb = this.setVersionBits(msb);
        lsb = this.setVariantBits(lsb);
        return new UUID(msb, lsb);
    }
}

