/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.nodeid;

import com.github.f4b6a3.uuid.nodeid.NodeIdentifierStrategy;
import com.github.f4b6a3.uuid.util.ByteUtil;
import com.github.f4b6a3.uuid.util.NetworkData;
import com.github.f4b6a3.uuid.util.NodeIdentifierUtil;
import com.github.f4b6a3.uuid.util.RandomUtil;
import com.github.f4b6a3.uuid.util.SystemDataUtil;
import java.util.List;

public class HardwareAddressNodeIdentifierStrategy
implements NodeIdentifierStrategy {
    protected long nodeIdentifier = this.getHardwareAddress();

    @Override
    public long getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    protected long getHardwareAddress() {
        String hardwareAddress;
        List<NetworkData> networkDataList;
        NetworkData networkData = SystemDataUtil.getNetworkData();
        if (networkData == null && (networkDataList = SystemDataUtil.getNetworkDataList()) != null && !networkDataList.isEmpty()) {
            networkData = networkDataList.get(0);
        }
        if (networkData != null && (hardwareAddress = networkData.getInterfaceHardwareAddress()) != null && !hardwareAddress.isEmpty()) {
            return ByteUtil.toNumber(networkData.getInterfaceHardwareAddress());
        }
        return this.getRandomMulticastNodeIdentifier();
    }

    protected long getRandomMulticastNodeIdentifier() {
        return NodeIdentifierUtil.setMulticastNodeIdentifier(RandomUtil.nextLong());
    }
}

