/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory;

import com.github.f4b6a3.uuid.exception.UuidCreatorException;
import com.github.f4b6a3.uuid.factory.abst.AbstractUuidCreator;
import com.github.f4b6a3.uuid.factory.abst.NoArgumentsUuidCreator;
import com.github.f4b6a3.uuid.timestamp.EpochMilliTimestampStretegy;
import com.github.f4b6a3.uuid.timestamp.TimestampStrategy;
import com.github.f4b6a3.uuid.util.ByteUtil;
import com.github.f4b6a3.uuid.util.RandomUtil;
import java.util.UUID;

public class LexicalOrderGuidCreator
extends AbstractUuidCreator
implements NoArgumentsUuidCreator {
    private long previousTimestamp;
    private long random1;
    private long random2;
    private long random3;
    protected static final String OVERFLOW_MESSAGE = "The system caused an overflow in the generator by requesting too many GUIDs.";
    protected TimestampStrategy timestampStrategy;

    public LexicalOrderGuidCreator() {
        this.reset();
        this.timestampStrategy = new EpochMilliTimestampStretegy();
    }

    @Override
    public synchronized UUID create() {
        long timestamp = this.timestampStrategy.getTimestamp();
        if (timestamp == this.previousTimestamp) {
            this.increment();
        } else {
            this.reset();
        }
        this.previousTimestamp = timestamp;
        long msb = timestamp << 16 | this.random3;
        long lsb = this.random2 << 32 | this.random1;
        return new UUID(msb, lsb);
    }

    protected void reset() {
        byte[] bytes = new byte[10];
        RandomUtil.nextBytes(bytes);
        this.random3 = ByteUtil.toNumber(bytes, 0, 2);
        this.random2 = ByteUtil.toNumber(bytes, 2, 6);
        this.random1 = ByteUtil.toNumber(bytes, 6, 10);
    }

    protected void increment() {
        ++this.random1;
        if (this.random1 > 0xFFFFFFFFL) {
            this.random1 = 0L;
            ++this.random2;
            if (this.random2 > 0xFFFFFFFFL) {
                this.random2 = 0L;
                ++this.random3;
                if (this.random3 > 65535L) {
                    this.random3 = 0L;
                    throw new UuidCreatorException(OVERFLOW_MESSAGE);
                }
            }
        }
    }

    public <T extends LexicalOrderGuidCreator> T withTimestampStrategy(TimestampStrategy timestampStrategy) {
        this.timestampStrategy = timestampStrategy;
        return (T)this;
    }
}

