/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.abst.AbstractUuidCreator;
import com.github.f4b6a3.uuid.factory.abst.NoArgumentsUuidCreator;
import com.github.f4b6a3.uuid.random.Xorshift128PlusRandom;
import com.github.f4b6a3.uuid.util.ByteUtil;
import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;

public class RandomUuidCreator
extends AbstractUuidCreator
implements NoArgumentsUuidCreator {
    private Random random;

    public RandomUuidCreator() {
        super(UuidVersion.RANDOM_BASED);
    }

    @Override
    public UUID create() {
        long msb = 0L;
        long lsb = 0L;
        if (this.random == null) {
            byte[] bytes = new byte[16];
            SecureRandomLazyHolder.INSTANCE.nextBytes(bytes);
            msb = ByteUtil.toNumber(bytes, 0, 8);
            lsb = ByteUtil.toNumber(bytes, 8, 16);
        } else {
            msb = this.random.nextLong();
            lsb = this.random.nextLong();
        }
        msb = this.setVersionBits(msb);
        lsb = this.setVariantBits(lsb);
        return new UUID(msb, lsb);
    }

    public RandomUuidCreator withRandomGenerator(Random random) {
        this.random = random;
        return this;
    }

    public RandomUuidCreator withFastRandomGenerator() {
        this.random = new Xorshift128PlusRandom();
        return this;
    }

    private static class SecureRandomLazyHolder {
        static final Random INSTANCE = new SecureRandom();

        private SecureRandomLazyHolder() {
        }
    }
}

