/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid;

import com.github.f4b6a3.uuid.exception.UuidCreatorException;
import com.github.f4b6a3.uuid.factory.CombGuidCreator;
import com.github.f4b6a3.uuid.factory.DceSecurityUuidCreator;
import com.github.f4b6a3.uuid.factory.MssqlGuidCreator;
import com.github.f4b6a3.uuid.factory.NameBasedMd5UuidCreator;
import com.github.f4b6a3.uuid.factory.NameBasedSha1UuidCreator;
import com.github.f4b6a3.uuid.factory.NameBasedSha256UuidCreator;
import com.github.f4b6a3.uuid.factory.RandomUuidCreator;
import com.github.f4b6a3.uuid.factory.SequentialUuidCreator;
import com.github.f4b6a3.uuid.factory.TimeBasedUuidCreator;
import java.util.UUID;

public class UuidCreator {
    private UuidCreator() {
    }

    public static UUID getRandom() {
        return RandomCreatorLazyHolder.INSTANCE.create();
    }

    public static UUID getFastRandom() {
        return FastRandomCreatorLazyHolder.INSTANCE.create();
    }

    public static UUID getSequential() {
        try {
            return SequentialCreatorLazyHolder.INSTANCE.create();
        }
        catch (UuidCreatorException e) {
            return SequentialCreatorLazyHolder.INSTANCE.create();
        }
    }

    public static UUID getSequentialWithMac() {
        try {
            return SequentialWithMacCreatorLazyHolder.INSTANCE.create();
        }
        catch (UuidCreatorException e) {
            return SequentialWithMacCreatorLazyHolder.INSTANCE.create();
        }
    }

    public static UUID getTimeBased() {
        try {
            return TimeBasedCreatorLazyHolder.INSTANCE.create();
        }
        catch (UuidCreatorException e) {
            return TimeBasedCreatorLazyHolder.INSTANCE.create();
        }
    }

    public static UUID getTimeBasedWithMac() {
        try {
            return TimeBasedWithMacCreatorLazyHolder.INSTANCE.create();
        }
        catch (UuidCreatorException e) {
            return TimeBasedWithMacCreatorLazyHolder.INSTANCE.create();
        }
    }

    public static UUID getDceSecurity(byte localDomain, int localIdentifier) {
        try {
            return DceSecurityCreatorLazyHolder.INSTANCE.create(localDomain, localIdentifier);
        }
        catch (UuidCreatorException e) {
            return DceSecurityCreatorLazyHolder.INSTANCE.create(localDomain, localIdentifier);
        }
    }

    public static UUID getDceSecurityWithMac(byte localDomain, int localIdentifier) {
        try {
            return DceSecurityWithMacCreatorLazyHolder.INSTANCE.create(localDomain, localIdentifier);
        }
        catch (UuidCreatorException e) {
            return DceSecurityWithMacCreatorLazyHolder.INSTANCE.create(localDomain, localIdentifier);
        }
    }

    public static UUID getNameBasedMd5(String name) {
        return NameBasedMd5CreatorLazyHolder.INSTANCE.create(name);
    }

    public static UUID getNameBasedMd5(UUID namespace, String name) {
        return NameBasedMd5CreatorLazyHolder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedSha1(String name) {
        return NameBasedSha1CreatorLazyHolder.INSTANCE.create(name);
    }

    public static UUID getNameBasedSha1(UUID namespace, String name) {
        return NameBasedSha1CreatorLazyHolder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedSha256(String name) {
        return NameBasedSha256CreatorLazyHolder.INSTANCE.create(name);
    }

    public static UUID getNameBasedSha256(UUID namespace, String name) {
        return NameBasedSha256CreatorLazyHolder.INSTANCE.create(namespace, name);
    }

    public static UUID getMssqlGuid() {
        try {
            return MssqlGuidCreatorLazyHolder.INSTANCE.create();
        }
        catch (UuidCreatorException e) {
            return MssqlGuidCreatorLazyHolder.INSTANCE.create();
        }
    }

    public static UUID getCombGuid() {
        return CombGuidCreatorLazyHolder.INSTANCE.create();
    }

    public static SequentialUuidCreator getSequentialCreator() {
        return new SequentialUuidCreator();
    }

    public static TimeBasedUuidCreator getTimeBasedCreator() {
        return new TimeBasedUuidCreator();
    }

    public static DceSecurityUuidCreator getDceSecurityCreator() {
        return new DceSecurityUuidCreator();
    }

    public static NameBasedMd5UuidCreator getNameBasedMd5Creator() {
        return new NameBasedMd5UuidCreator();
    }

    public static RandomUuidCreator getRandomCreator() {
        return new RandomUuidCreator();
    }

    public static RandomUuidCreator getFastRandomCreator() {
        return new RandomUuidCreator().withFastRandomGenerator();
    }

    public static NameBasedSha1UuidCreator getNameBasedSha1Creator() {
        return new NameBasedSha1UuidCreator();
    }

    public static NameBasedSha256UuidCreator getNameBasedSha256Creator() {
        return new NameBasedSha256UuidCreator();
    }

    public static MssqlGuidCreator getMssqlGuidCreator() {
        return new MssqlGuidCreator();
    }

    public static CombGuidCreator getCombGuidCreator() {
        return new CombGuidCreator();
    }

    private static class CombGuidCreatorLazyHolder {
        static final CombGuidCreator INSTANCE = UuidCreator.getCombGuidCreator();

        private CombGuidCreatorLazyHolder() {
        }
    }

    private static class MssqlGuidCreatorLazyHolder {
        static final MssqlGuidCreator INSTANCE = UuidCreator.getMssqlGuidCreator();

        private MssqlGuidCreatorLazyHolder() {
        }
    }

    private static class DceSecurityWithMacCreatorLazyHolder {
        static final DceSecurityUuidCreator INSTANCE = (DceSecurityUuidCreator)UuidCreator.getDceSecurityCreator().withHardwareAddress();

        private DceSecurityWithMacCreatorLazyHolder() {
        }
    }

    private static class DceSecurityCreatorLazyHolder {
        static final DceSecurityUuidCreator INSTANCE = UuidCreator.getDceSecurityCreator();

        private DceSecurityCreatorLazyHolder() {
        }
    }

    private static class NameBasedSha256CreatorLazyHolder {
        static final NameBasedSha256UuidCreator INSTANCE = UuidCreator.getNameBasedSha256Creator();

        private NameBasedSha256CreatorLazyHolder() {
        }
    }

    private static class NameBasedSha1CreatorLazyHolder {
        static final NameBasedSha1UuidCreator INSTANCE = UuidCreator.getNameBasedSha1Creator();

        private NameBasedSha1CreatorLazyHolder() {
        }
    }

    private static class NameBasedMd5CreatorLazyHolder {
        static final NameBasedMd5UuidCreator INSTANCE = UuidCreator.getNameBasedMd5Creator();

        private NameBasedMd5CreatorLazyHolder() {
        }
    }

    private static class TimeBasedWithMacCreatorLazyHolder {
        static final TimeBasedUuidCreator INSTANCE = (TimeBasedUuidCreator)UuidCreator.getTimeBasedCreator().withHardwareAddress();

        private TimeBasedWithMacCreatorLazyHolder() {
        }
    }

    private static class TimeBasedCreatorLazyHolder {
        static final TimeBasedUuidCreator INSTANCE = UuidCreator.getTimeBasedCreator();

        private TimeBasedCreatorLazyHolder() {
        }
    }

    private static class SequentialWithMacCreatorLazyHolder {
        static final SequentialUuidCreator INSTANCE = (SequentialUuidCreator)UuidCreator.getSequentialCreator().withHardwareAddress();

        private SequentialWithMacCreatorLazyHolder() {
        }
    }

    private static class SequentialCreatorLazyHolder {
        static final SequentialUuidCreator INSTANCE = UuidCreator.getSequentialCreator();

        private SequentialCreatorLazyHolder() {
        }
    }

    private static class FastRandomCreatorLazyHolder {
        static final RandomUuidCreator INSTANCE = UuidCreator.getFastRandomCreator();

        private FastRandomCreatorLazyHolder() {
        }
    }

    private static class RandomCreatorLazyHolder {
        static final RandomUuidCreator INSTANCE = UuidCreator.getRandomCreator();

        private RandomCreatorLazyHolder() {
        }
    }
}

