/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.state;

import com.github.f4b6a3.uuid.state.AbstractUuidState;
import com.github.f4b6a3.uuid.util.ByteUtil;
import com.github.f4b6a3.uuid.util.SettingsUtil;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;

public class FileUuidState
extends AbstractUuidState {
    private static final String FILE_NAME = "uuidcreator";
    private static final String FILE_EXTENSION = "state";
    private static final String PROPERTY_TIMESTAMP = "timestamp";
    private static final String PROPERTY_CLOCKSEQ = "clockseq";
    private static final String PROPERTY_NODEID = "nodeid";
    private String directory = SettingsUtil.getStateDirectory();
    private String fileName;
    private boolean valid;

    public FileUuidState() {
        this.updateFileName();
        this.load();
    }

    private void updateFileName() {
        this.fileName = String.join((CharSequence)"/", this.directory, FILE_NAME);
        this.fileName = String.join((CharSequence)".", this.fileName, FILE_EXTENSION);
    }

    @Override
    public void store() {
        try (FileWriter file = new FileWriter(this.fileName);){
            String timestampHex = ByteUtil.toHexadecimal(this.timestamp);
            String clockseqHex = ByteUtil.toHexadecimal(this.clockSequence);
            String nodeidHex = ByteUtil.toHexadecimal(this.nodeIdentifier);
            this.validate(timestampHex, clockseqHex, nodeidHex);
            if (this.valid) {
                Properties properties = new Properties();
                properties.setProperty(PROPERTY_TIMESTAMP, timestampHex);
                properties.setProperty(PROPERTY_CLOCKSEQ, clockseqHex);
                properties.setProperty(PROPERTY_NODEID, nodeidHex);
                properties.store(file, null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void load() {
        try (FileReader file = new FileReader(this.fileName);){
            Properties properties = new Properties();
            properties.load(file);
            String timestampHex = properties.getProperty(PROPERTY_TIMESTAMP, "0");
            String clockseqHex = properties.getProperty(PROPERTY_CLOCKSEQ, "0");
            String nodeidHex = properties.getProperty(PROPERTY_NODEID, "0");
            this.validate(timestampHex, clockseqHex, nodeidHex);
            if (this.valid) {
                this.timestamp = ByteUtil.toNumber(timestampHex);
                this.clockSequence = (int)ByteUtil.toNumber(clockseqHex) & 0x3FFF;
                this.nodeIdentifier = ByteUtil.toNumber(nodeidHex) & 0xFFFFFFFFFFFFL;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    private void validate(String timestampHex, String clockseqHex, String nodeidHex) {
        String zero = "^[0]{1,16}$";
        String hexa = "[0-9a-fA-F]{1,16}";
        boolean validTimestamp = timestampHex != null && timestampHex.matches(hexa) && !timestampHex.matches(zero);
        boolean validClockseq = clockseqHex != null && clockseqHex.matches(hexa) && !clockseqHex.matches(zero);
        boolean validNodeid = nodeidHex != null && nodeidHex.matches(hexa) && !nodeidHex.matches(zero);
        this.valid = validTimestamp && validClockseq && validNodeid;
    }
}

