/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

import com.github.f4b6a3.uuid.util.ByteUtil;

public class SettingsUtil {
    protected static final String PROPERTY_PREFIX = "uuidcreator";
    public static final String PROPERTY_NODEID = "nodeid";
    public static final String PROPERTY_NODEID_SALT = "nodeid.salt";
    public static final String PROPERTY_STATE_DIRECTORY = "state.directory";
    public static final String PROPERTY_STATE_ENABLED = "state.enabled";
    private static final String[] trueValues = new String[]{"true", "t", "yes", "y", "on", "1"};

    public static long getNodeIdentifier() {
        String value = SettingsUtil.getProperty(PROPERTY_NODEID);
        if (value == null) {
            return 0L;
        }
        return ByteUtil.toNumber(value) & 0xFFFFFFFFFFFFL;
    }

    public static void setNodeIdentifier(long nodeid) {
        String value = ByteUtil.toHexadecimal(nodeid & 0xFFFFFFFFFFFFL);
        SettingsUtil.setProperty(PROPERTY_NODEID, value);
    }

    public static String getNodeIdentifierSalt() {
        return SettingsUtil.getProperty(PROPERTY_NODEID_SALT);
    }

    public static void setNodeIdentifierString(String salt) {
        SettingsUtil.setProperty(PROPERTY_NODEID_SALT, salt);
    }

    public static String getStateDirectory() {
        String value = SettingsUtil.getProperty(PROPERTY_STATE_DIRECTORY);
        if (value == null) {
            return System.getProperty("java.io.tmpdir");
        }
        return value;
    }

    public static void setStateDirectory(String directory) {
        String value = directory.replaceAll("/$", "");
        SettingsUtil.setProperty(PROPERTY_STATE_DIRECTORY, value);
    }

    public static boolean isStateEnabled() {
        String value = SettingsUtil.getProperty(PROPERTY_STATE_ENABLED);
        if (value == null) {
            return false;
        }
        return SettingsUtil.isTrue(value);
    }

    public static void setStateEnabled(boolean enabled) {
        SettingsUtil.setProperty(PROPERTY_STATE_ENABLED, String.valueOf(enabled));
    }

    private static String getProperty(String name) {
        String fullName = SettingsUtil.getPropertyName(name);
        String value = System.getProperty(fullName);
        if (!SettingsUtil.isEmpty(value)) {
            return value;
        }
        fullName = SettingsUtil.getEnvinronmentName(name);
        value = System.getenv(fullName);
        if (!SettingsUtil.isEmpty(value)) {
            return value;
        }
        return null;
    }

    private static void setProperty(String key, String value) {
        System.setProperty(SettingsUtil.getPropertyName(key), value);
    }

    private static String getPropertyName(String key) {
        return String.join((CharSequence)".", PROPERTY_PREFIX, key);
    }

    private static String getEnvinronmentName(String key) {
        return String.join((CharSequence)"_", PROPERTY_PREFIX, key).toUpperCase().replace(".", "_");
    }

    private static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    private static boolean isTrue(String value) {
        int n = 0;
        String[] stringArray = trueValues;
        int n2 = stringArray.length;
        if (n < n2) {
            String t = stringArray[n];
            return value.toLowerCase().equals(t);
        }
        return false;
    }
}

