/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.TimeBasedUuidCreator;
import com.github.f4b6a3.uuid.sequence.AbstractSequence;
import java.util.UUID;

public class DceSecurityUuidCreator
extends TimeBasedUuidCreator {
    public static final byte LOCAL_DOMAIN_PERSON = 0;
    public static final byte LOCAL_DOMAIN_GROUP = 1;
    public static final byte LOCAL_DOMAIN_ORG = 2;
    protected TimeBasedUuidCreator timeBasedUUIDCreator;
    protected DCESTimestampCounter timestampCounter = new DCESTimestampCounter();
    protected byte localDomain;

    public DceSecurityUuidCreator() {
        super(UuidVersion.DCE_SECURITY);
    }

    @Override
    public UUID create() {
        throw new RuntimeException("Not implemented.");
    }

    public synchronized UUID create(byte localDomain, int localIdentifier) {
        UUID uuid = super.create();
        long msb = DceSecurityUuidCreator.setLocalIdentifierBits(uuid.getMostSignificantBits(), localIdentifier);
        int counter = this.timestampCounter.next();
        long lsb = DceSecurityUuidCreator.setLocalDomainBits(uuid.getLeastSignificantBits(), localDomain, counter);
        return new UUID(this.setVersionBits(msb), lsb);
    }

    public UUID create(int localIdentifier) {
        return this.create((byte)0, localIdentifier);
    }

    protected static long setLocalIdentifierBits(long msb, int localIdentifier) {
        return msb & 0xFFFFFFFFL | (long)localIdentifier << 32;
    }

    protected static long setLocalDomainBits(long lsb, byte localDomain, int counter) {
        return lsb & 0xFF00FFFFFFFFFFFFL | (long)localDomain << 48 | (long)counter << 56;
    }

    public DceSecurityUuidCreator withLocalDomain(byte localDomain) {
        this.localDomain = localDomain;
        return this;
    }

    protected class DCESTimestampCounter
    extends AbstractSequence {
        private static final int COUNTER_MIN = 0;
        private static final int COUNTER_MAX = 63;

        protected DCESTimestampCounter() {
            super(0, 63);
        }
    }
}

