/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.clockseq;

import com.github.f4b6a3.uuid.clockseq.ClockSequenceStrategy;
import com.github.f4b6a3.uuid.exception.OverrunException;
import com.github.f4b6a3.uuid.sequence.AbstractSequence;
import com.github.f4b6a3.uuid.state.AbstractUuidState;
import com.github.f4b6a3.uuid.state.FileUuidState;
import com.github.f4b6a3.uuid.util.RandomUtil;
import com.github.f4b6a3.uuid.util.SettingsUtil;

public class DefaultClockSequenceStrategy
extends AbstractSequence
implements ClockSequenceStrategy {
    private long timestamp = 0L;
    private long nodeIdentifier = 0L;
    private int counter = 0;
    protected AbstractUuidState state;
    protected static final int SEQUENCE_MIN = 0;
    protected static final int SEQUENCE_MAX = 16383;

    public DefaultClockSequenceStrategy(long timestamp, long nodeIdentifier, AbstractUuidState state) {
        super(0, 16383);
        this.timestamp = timestamp;
        this.nodeIdentifier = nodeIdentifier;
        if (SettingsUtil.isStateEnabled()) {
            this.addShutdownHook();
            this.state = state;
            if (this.state == null) {
                this.state = new FileUuidState();
            }
            if (!this.state.isValid()) {
                this.reset();
                return;
            }
            long lastTimestamp = this.state.getTimestamp();
            long lastNodeIdentifier = this.state.getNodeIdentifier();
            int lastClockSequence = this.state.getClockSequence();
            this.set(lastClockSequence);
            if (this.timestamp <= lastTimestamp || this.nodeIdentifier != lastNodeIdentifier) {
                this.next();
            }
        } else {
            this.reset();
        }
    }

    public DefaultClockSequenceStrategy(long timestamp, long nodeIdentifier) {
        this(timestamp, nodeIdentifier, null);
    }

    public DefaultClockSequenceStrategy() {
        this(0L, 0L, null);
    }

    @Override
    public int getClockSequence(long timestamp, long nodeIdentifier) {
        if (timestamp <= this.timestamp) {
            if (this.counter >= 16383) {
                throw new OverrunException("Too many requests.");
            }
            ++this.counter;
            this.timestamp = timestamp;
            return this.next();
        }
        this.counter = 0;
        this.timestamp = timestamp;
        return this.current();
    }

    @Override
    public void reset() {
        this.value = RandomUtil.nextInt(16383);
    }

    protected void storeState() {
        if (SettingsUtil.isStateEnabled()) {
            this.state.setNodeIdentifier(this.nodeIdentifier);
            this.state.setTimestamp(this.timestamp);
            this.state.setClockSequence(this.value);
            this.state.store();
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new DefaultClockSequenceShutdownHook(this));
    }

    protected static class DefaultClockSequenceShutdownHook
    extends Thread {
        private DefaultClockSequenceStrategy strategy;

        public DefaultClockSequenceShutdownHook(DefaultClockSequenceStrategy strategy) {
            this.strategy = strategy;
        }

        @Override
        public void run() {
            this.strategy.storeState();
        }
    }
}

