/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.sequence;

import com.github.f4b6a3.uuid.sequence.Sequence;

public abstract class AbstractSequence
implements Sequence {
    protected int value;
    public final int MIN_VALUE;
    public final int MAX_VALUE;

    protected AbstractSequence(int min, int max) {
        this.MIN_VALUE = min;
        this.MAX_VALUE = max;
        this.value = this.MIN_VALUE;
    }

    @Override
    public int current() {
        return this.value;
    }

    @Override
    public int next() {
        if (this.value >= this.MAX_VALUE) {
            this.value = this.MIN_VALUE;
            return this.value;
        }
        return ++this.value;
    }

    @Override
    public int min() {
        return this.MIN_VALUE;
    }

    @Override
    public int max() {
        return this.MAX_VALUE;
    }

    @Override
    public void reset() {
        this.value = this.MIN_VALUE;
    }

    @Override
    public void set(int value) {
        if (value < this.MIN_VALUE || value > this.MAX_VALUE) {
            this.reset();
        }
        this.value = value;
    }
}

