/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

import com.github.f4b6a3.uuid.util.ByteUtil;

public class SettingsUtil {
    public static final String PROPERTY_PREFIX = "uuidcreator";
    public static final String PROPERTY_CLOCKSEQ = "clockseq";
    public static final String PROPERTY_NODEID = "nodeid";
    public static final String PROPERTY_STATE_DIRECTORY = "state.directory";
    public static final String PROPERTY_STATE_ENABLED = "state.enabled";

    public static long getNodeIdentifier() {
        String value = SettingsUtil.getProperty(PROPERTY_NODEID);
        if (value == null) {
            return 0L;
        }
        return ByteUtil.toNumber(value) & 0xFFFFFFFFFFFFL;
    }

    public static int getClockSequence() {
        String value = SettingsUtil.getProperty(PROPERTY_CLOCKSEQ);
        if (value == null) {
            return 0;
        }
        return (int)ByteUtil.toNumber(value) & 0x3FFF;
    }

    public static String getStateDirectory() {
        String value = SettingsUtil.getProperty(PROPERTY_STATE_DIRECTORY);
        if (value == null) {
            return System.getProperty("java.io.tmpdir");
        }
        return value;
    }

    public static boolean isStateEnabled() {
        String value = SettingsUtil.getProperty(PROPERTY_STATE_ENABLED);
        if (value == null) {
            return false;
        }
        return value.equals("true");
    }

    private static String getProperty(String name) {
        String fullName = SettingsUtil.getPropertyName(name);
        String value = System.getProperty(fullName);
        if (!SettingsUtil.isEmpty(value)) {
            return value;
        }
        fullName = SettingsUtil.getEnvinronmentName(name);
        value = System.getenv(fullName);
        if (!SettingsUtil.isEmpty(value)) {
            return value;
        }
        return null;
    }

    private static String getPropertyName(String key) {
        return String.join((CharSequence)".", PROPERTY_PREFIX, key);
    }

    private static String getEnvinronmentName(String key) {
        return String.join((CharSequence)"_", PROPERTY_PREFIX, key).toUpperCase().replace(".", "_");
    }

    private static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }
}

