/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

public class SettingsUtil {
    public static final String PROPERTY_PREFIX = "uuidcreator";
    public static final String PROPERTY_CLOCKSEQ = "clockseq";
    public static final String PROPERTY_NODEID = "nodeid";

    public static long getNodeIdentifier() {
        String nodeid = SettingsUtil.getProperty(PROPERTY_NODEID);
        if (nodeid == null) {
            return 0L;
        }
        return SettingsUtil.toNumber(nodeid) & 0xFFFFFFFFFFFFL;
    }

    public static int getClockSequence() {
        String clockseq = SettingsUtil.getProperty(PROPERTY_CLOCKSEQ);
        if (clockseq == null) {
            return 0;
        }
        return (int)SettingsUtil.toNumber(clockseq) & 0x3FFF;
    }

    private static String getProperty(String name) {
        String fullName = SettingsUtil.getPropertyName(name);
        String value = System.getProperty(fullName);
        if (!SettingsUtil.isEmpty(value)) {
            return value;
        }
        fullName = SettingsUtil.getEnvinronmentName(name);
        value = System.getenv(fullName);
        if (!SettingsUtil.isEmpty(value)) {
            return value;
        }
        return null;
    }

    private static String getPropertyName(String key) {
        return String.join((CharSequence)".", PROPERTY_PREFIX, key);
    }

    private static String getEnvinronmentName(String key) {
        return String.join((CharSequence)"_", PROPERTY_PREFIX, key).toUpperCase();
    }

    private static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    private static long toNumber(String value) {
        try {
            return Long.decode(value);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }
}

