/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.random;

import java.util.Random;

public class Xoroshiro128PlusRandom
extends Random {
    private static final long serialVersionUID = -7444349550311614229L;
    long[] seed = new long[2];

    public Xoroshiro128PlusRandom() {
        long nanotime = System.nanoTime();
        long hashcode = this.hashCode();
        this.seed[0] = nanotime << 32 ^ nanotime;
        this.seed[1] = hashcode << 32 ^ hashcode;
    }

    public Xoroshiro128PlusRandom(long[] seed) {
        this.seed = seed;
    }

    @Override
    protected int next(int bits) {
        return (int)(this.nextLong() >>> 64 - bits);
    }

    @Override
    public long nextLong() {
        long s0 = this.seed[0];
        long s1 = this.seed[1];
        long result = s0 + s1;
        this.seed[0] = Xoroshiro128PlusRandom.rotateLeft(s0, 24) ^ (s1 ^= s0) ^ s1 << 16;
        this.seed[1] = Xoroshiro128PlusRandom.rotateLeft(s1, 37);
        return result;
    }

    private static long rotateLeft(long x, int k) {
        return x << k | x >>> 64 - k;
    }
}

