/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.clockseq;

import com.github.f4b6a3.uuid.clockseq.ClockSequenceStrategy;
import com.github.f4b6a3.uuid.exception.OverrunException;
import com.github.f4b6a3.uuid.sequence.AbstractSequence;
import com.github.f4b6a3.uuid.util.RandomUtil;
import com.github.f4b6a3.uuid.util.SettingsUtil;

public class DefaultClockSequenceStrategy
extends AbstractSequence
implements ClockSequenceStrategy {
    private long timestamp = 0L;
    private int counter = 0;
    protected static final int SEQUENCE_MIN = 0;
    protected static final int SEQUENCE_MAX = 16383;

    public DefaultClockSequenceStrategy() {
        super(0, 16383);
        this.value = SettingsUtil.getClockSequence();
        if (this.value == 0) {
            this.reset();
        }
    }

    @Override
    public int getClockSequence(long timestamp, long nodeIdentifier) {
        if (timestamp <= this.timestamp) {
            if (this.counter >= 16383) {
                throw new OverrunException("Too many requests.");
            }
            ++this.counter;
            this.timestamp = timestamp;
            return this.next();
        }
        this.counter = 0;
        this.timestamp = timestamp;
        return this.current();
    }

    @Override
    public void reset() {
        this.value = RandomUtil.nextInt(16383);
    }
}

