/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.ulid;

import com.github.f4b6a3.ulid.Ulid;
import com.github.f4b6a3.ulid.UlidFactory;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public final class UlidCreator {
    private static final Proxy FACTORY = new Proxy(UlidFactory::newInstance);
    private static final Proxy MONOTONIC_FACTORY = new Proxy(UlidFactory::newMonotonicInstance);

    private UlidCreator() {
    }

    public static Ulid getUlid() {
        return FACTORY.create();
    }

    public static Ulid getUlid(long time) {
        return FACTORY.create(time);
    }

    public static Ulid getMonotonicUlid() {
        return MONOTONIC_FACTORY.create();
    }

    public static Ulid getMonotonicUlid(long time) {
        return MONOTONIC_FACTORY.create(time);
    }

    public static Ulid getHashUlid(long time, String string) {
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        return UlidCreator.getHashUlid(time, bytes);
    }

    public static Ulid getHashUlid(long time, byte[] bytes) {
        byte[] hash = UlidCreator.hasher("SHA-256").digest(bytes);
        byte[] rand = Arrays.copyOf(hash, 10);
        return new Ulid(time, rand);
    }

    private static MessageDigest hasher(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(String.format("%s not supported", algorithm));
        }
    }

    private static class Proxy {
        private UlidFactory factory = null;
        private Supplier<UlidFactory> supplier;
        private static final ReentrantLock lock = new ReentrantLock();

        public Proxy(Supplier<UlidFactory> supplier) {
            this.supplier = supplier;
        }

        private UlidFactory get() {
            if (this.factory != null) {
                return this.factory;
            }
            lock.lock();
            try {
                if (this.factory == null) {
                    this.factory = this.supplier.get();
                }
                UlidFactory ulidFactory = this.factory;
                return ulidFactory;
            }
            finally {
                lock.unlock();
            }
        }

        public Ulid create() {
            return this.get().create();
        }

        public Ulid create(long time) {
            return this.get().create(time);
        }
    }
}

