/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.ulid;

import com.github.f4b6a3.ulid.Ulid;
import java.security.SecureRandom;
import java.util.Random;
import java.util.function.LongFunction;
import java.util.function.Supplier;

public final class UlidFactory {
    private final LongFunction<Ulid> ulidFunction;

    public UlidFactory() {
        this.ulidFunction = new UlidFunction();
    }

    private UlidFactory(LongFunction<Ulid> ulidFunction) {
        this.ulidFunction = ulidFunction;
    }

    public static UlidFactory newInstance() {
        return new UlidFactory(new UlidFunction());
    }

    public static UlidFactory newInstance(Random random) {
        return new UlidFactory(new UlidFunction(random));
    }

    public static UlidFactory newInstance(Supplier<byte[]> randomSupplier) {
        return new UlidFactory(new UlidFunction(randomSupplier));
    }

    public static UlidFactory newMonotonicInstance() {
        return new UlidFactory(new MonotonicFunction());
    }

    public static UlidFactory newMonotonicInstance(Random random) {
        return new UlidFactory(new MonotonicFunction(random));
    }

    public static UlidFactory newMonotonicInstance(Supplier<byte[]> randomSupplier) {
        return new UlidFactory(new MonotonicFunction(randomSupplier));
    }

    public Ulid create() {
        return this.create(System.currentTimeMillis());
    }

    public Ulid create(long time) {
        return this.ulidFunction.apply(time);
    }

    protected static Supplier<byte[]> getRandomSupplier(Random random) {
        return () -> {
            byte[] payload = new byte[10];
            random.nextBytes(payload);
            return payload;
        };
    }

    protected static final class MonotonicFunction
    implements LongFunction<Ulid> {
        private long lastTime = -1L;
        private Ulid lastUlid = null;
        private Supplier<byte[]> randomSupplier;

        public MonotonicFunction() {
            this(new SecureRandom());
        }

        public MonotonicFunction(Random random) {
            this(UlidFactory.getRandomSupplier(random));
        }

        public MonotonicFunction(Supplier<byte[]> randomSupplier) {
            this.randomSupplier = randomSupplier;
        }

        @Override
        public synchronized Ulid apply(long time) {
            this.lastUlid = time == this.lastTime ? this.lastUlid.increment() : new Ulid(time, this.randomSupplier.get());
            this.lastTime = time;
            return new Ulid(this.lastUlid);
        }
    }

    protected static final class UlidFunction
    implements LongFunction<Ulid> {
        private Supplier<byte[]> randomSupplier;

        public UlidFunction() {
            this(new SecureRandom());
        }

        public UlidFunction(Random random) {
            this(UlidFactory.getRandomSupplier(random));
        }

        public UlidFunction(Supplier<byte[]> randomSupplier) {
            this.randomSupplier = randomSupplier;
        }

        @Override
        public Ulid apply(long time) {
            return new Ulid(time, this.randomSupplier.get());
        }
    }
}

