/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.ulid.util;

import com.github.f4b6a3.ulid.exception.InvalidUlidException;
import com.github.f4b6a3.ulid.util.UlidUtil;

public final class UlidValidator {
    protected static final long TIMESTAMP_MAX = (long)Math.pow(2.0, 48.0) - 1L;

    private UlidValidator() {
    }

    public static boolean isValid(String ulid) {
        if (ulid == null) {
            return false;
        }
        char[] chars = UlidUtil.removeHyphens(ulid.toCharArray());
        if (chars.length != 26 || !UlidUtil.isCrockfordBase32(chars)) {
            return false;
        }
        char[] timestampComponent = new char[10];
        System.arraycopy(chars, 0, timestampComponent, 0, 10);
        long timestamp = UlidUtil.fromBase32Crockford(timestampComponent);
        return timestamp >= 0L && timestamp <= TIMESTAMP_MAX;
    }

    protected static void validate(String ulid) {
        if (!UlidValidator.isValid(ulid)) {
            throw new InvalidUlidException(String.format("Invalid ULID: %s.", ulid));
        }
    }
}

