/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.ulid.util;

import com.github.f4b6a3.ulid.util.UlidUtil;
import com.github.f4b6a3.ulid.util.UlidValidator;
import java.util.UUID;

public final class UlidConverter {
    private UlidConverter() {
    }

    public static String toString(UUID uuid) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        long time = (msb & 0xFFFFFFFFFFFF0000L) >>> 16;
        long random1 = (msb & 0xFFFFL) << 24 | (lsb & 0xFFFFFF0000000000L) >>> 40;
        long random2 = lsb & 0xFFFFFFFFFFL;
        char[] timeComponent = UlidUtil.zerofill(UlidUtil.toBase32Crockford(time), 10);
        char[] randomComponent1 = UlidUtil.zerofill(UlidUtil.toBase32Crockford(random1), 8);
        char[] randomComponent2 = UlidUtil.zerofill(UlidUtil.toBase32Crockford(random2), 8);
        char[] output = new char[26];
        System.arraycopy(timeComponent, 0, output, 0, 10);
        System.arraycopy(randomComponent1, 0, output, 10, 8);
        System.arraycopy(randomComponent2, 0, output, 18, 8);
        return new String(output);
    }

    public static UUID fromString(String ulid) {
        UlidValidator.validate(ulid);
        char[] input = ulid.toCharArray();
        char[] timeComponent = new char[10];
        char[] randomComponent1 = new char[8];
        char[] randomComponent2 = new char[8];
        System.arraycopy(input, 0, timeComponent, 0, 10);
        System.arraycopy(input, 10, randomComponent1, 0, 8);
        System.arraycopy(input, 18, randomComponent2, 0, 8);
        long time = UlidUtil.fromBase32Crockford(timeComponent);
        long random1 = UlidUtil.fromBase32Crockford(randomComponent1);
        long random2 = UlidUtil.fromBase32Crockford(randomComponent2);
        long msb = (time & 0xFFFFFFFFFFFFL) << 16 | (random1 & 0xFFFF000000L) >>> 24;
        long lsb = (random1 & 0xFFFFFFL) << 40 | random2 & 0xFFFFFFFFFFL;
        return new UUID(msb, lsb);
    }
}

