/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.ulid.util;

import com.github.f4b6a3.ulid.exception.InvalidUlidException;
import com.github.f4b6a3.ulid.util.UlidUtil;

public class UlidValidator {
    protected static final String ULID_PATTERN = "^[0-9a-tv-zA-TV-Z]{26}$";
    protected static final long TIMESTAMP_MAX = (long)Math.pow(2.0, 48.0) - 1L;

    private UlidValidator() {
    }

    public static boolean isValid(String ulid) {
        if (ulid == null || ulid.isEmpty()) {
            return false;
        }
        String u = ulid.replaceAll("-", "");
        if (!u.matches(ULID_PATTERN)) {
            return false;
        }
        long timestamp = UlidUtil.extractUnixMilliseconds(ulid);
        return timestamp >= 0L && timestamp <= TIMESTAMP_MAX;
    }

    protected static void validate(String ulid) {
        if (!UlidValidator.isValid(ulid)) {
            throw new InvalidUlidException(String.format("Invalid ULID: %s.", ulid));
        }
    }
}

