/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.ulid.util;

import com.github.f4b6a3.commons.util.Base32Util;
import com.github.f4b6a3.ulid.util.UlidValidator;
import java.time.Instant;

public class UlidUtil {
    private UlidUtil() {
    }

    public static long extractTimestamp(String ulid) {
        UlidValidator.validate(ulid);
        return UlidUtil.extractUnixMilliseconds(ulid);
    }

    public static Instant extractInstant(String ulid) {
        long milliseconds = UlidUtil.extractTimestamp(ulid);
        return Instant.ofEpochMilli(milliseconds);
    }

    public static String extractTimestampComponent(String ulid) {
        UlidValidator.validate(ulid);
        return ulid.substring(0, 10);
    }

    public static String extractRandomnessComponent(String ulid) {
        UlidValidator.validate(ulid);
        return ulid.substring(10, 26);
    }

    protected static long extractUnixMilliseconds(String ulid) {
        String milliseconds = ulid.substring(0, 10);
        return Base32Util.fromBase32CrockfordAsLong((String)milliseconds);
    }
}

