/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.ulid.util;

import com.github.f4b6a3.ulid.util.ByteUtil;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class NetworkData {
    private String hostName;
    private String hostCanonicalName;
    private String interfaceName;
    private String interfaceDisplayName;
    private String interfaceHardwareAddress;
    private List<String> interfaceAddresses;

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getHostCanonicalName() {
        return this.hostCanonicalName;
    }

    public void setHostCanonicalName(String hostCanonicalName) {
        this.hostCanonicalName = hostCanonicalName;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public String getInterfaceDisplayName() {
        return this.interfaceDisplayName;
    }

    public void setInterfaceDisplayName(String interfaceDisplayName) {
        this.interfaceDisplayName = interfaceDisplayName;
    }

    public String getInterfaceHardwareAddress() {
        return this.interfaceHardwareAddress;
    }

    public void setInterfaceHardwareAddress(String interfaceHardwareAddress) {
        this.interfaceHardwareAddress = interfaceHardwareAddress;
    }

    public List<String> getInterfaceAddresses() {
        return this.interfaceAddresses;
    }

    public void setInterfaceAddresses(List<String> interfaceAddresses) {
        this.interfaceAddresses = interfaceAddresses;
    }

    public String toString() {
        String interfaceAddressesString = null;
        if (this.interfaceAddresses != null) {
            interfaceAddressesString = String.join((CharSequence)" ", this.interfaceAddresses);
        }
        return String.join((CharSequence)" ", this.interfaceHardwareAddress, this.hostName, this.hostCanonicalName, this.interfaceName, this.interfaceDisplayName, interfaceAddressesString);
    }

    public static NetworkData getNetworkData() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(inetAddress);
            return NetworkData.buildNetworkData(networkInterface, inetAddress);
        }
        catch (SocketException | UnknownHostException e) {
            return null;
        }
    }

    public static List<NetworkData> getNetworkDataList() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            ArrayList<NetworkInterface> networkInterfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            HashSet<NetworkData> networkDataHashSet = new HashSet<NetworkData>();
            for (NetworkInterface networkInterface : networkInterfaces) {
                NetworkData networkData = NetworkData.buildNetworkData(networkInterface, inetAddress);
                if (networkData == null) continue;
                networkDataHashSet.add(networkData);
            }
            return new ArrayList<NetworkData>(networkDataHashSet);
        }
        catch (NullPointerException | SocketException | UnknownHostException e) {
            return Collections.emptyList();
        }
    }

    private static NetworkData buildNetworkData(NetworkInterface networkInterface, InetAddress inetAddress) throws SocketException {
        if (NetworkData.isPhysicalNetworkInterface(networkInterface)) {
            String hostName = inetAddress != null ? inetAddress.getHostName() : null;
            String hostCanonicalName = inetAddress != null ? inetAddress.getCanonicalHostName() : null;
            String interfaceName = networkInterface.getName();
            String interfaceDisplayName = networkInterface.getDisplayName();
            String interfaceHardwareAddress = ByteUtil.toHexadecimal(networkInterface.getHardwareAddress());
            List<String> interfaceAddresses = NetworkData.getInterfaceAddresses(networkInterface);
            NetworkData networkData = new NetworkData();
            networkData.setHostName(hostName);
            networkData.setHostCanonicalName(hostCanonicalName);
            networkData.setInterfaceName(interfaceName);
            networkData.setInterfaceDisplayName(interfaceDisplayName);
            networkData.setInterfaceHardwareAddress(interfaceHardwareAddress);
            networkData.setInterfaceAddresses(interfaceAddresses);
            return networkData;
        }
        return null;
    }

    private static boolean isPhysicalNetworkInterface(NetworkInterface networkInterface) {
        try {
            return networkInterface != null && networkInterface.isUp() && !networkInterface.isLoopback() && !networkInterface.isVirtual();
        }
        catch (SocketException e) {
            return false;
        }
    }

    private static List<String> getInterfaceAddresses(NetworkInterface networkInterface) {
        HashSet<String> addresses = new HashSet<String>();
        List<InterfaceAddress> interfaceAddresses = networkInterface.getInterfaceAddresses();
        if (interfaceAddresses != null && !interfaceAddresses.isEmpty()) {
            for (InterfaceAddress addr : interfaceAddresses) {
                if (addr.getAddress() == null) continue;
                addresses.add(addr.getAddress().getHostAddress());
            }
        }
        return new ArrayList<String>(addresses);
    }
}

