/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.ulid.util;

public class ByteUtil {
    private ByteUtil() {
    }

    public static long toNumber(String hexadecimal) {
        return ByteUtil.toNumber(ByteUtil.toBytes(hexadecimal));
    }

    public static long toNumber(byte[] bytes) {
        return ByteUtil.toNumber(bytes, 0, bytes.length);
    }

    public static long toNumber(byte[] bytes, int start, int end) {
        long result = 0L;
        for (int i = start; i < end; ++i) {
            result = result << 8 | (long)(bytes[i] & 0xFF);
        }
        return result;
    }

    public static byte[] toBytes(long number) {
        return new byte[]{(byte)(number >>> 56), (byte)(number >>> 48), (byte)(number >>> 40), (byte)(number >>> 32), (byte)(number >>> 24), (byte)(number >>> 16), (byte)(number >>> 8), (byte)number};
    }

    public static byte[] toBytes(String hexadecimal) {
        int length = hexadecimal.length();
        byte[] bytes = new byte[length / 2];
        for (int i = 0; i < length; i += 2) {
            bytes[i / 2] = (byte)(ByteUtil.fromHexChar(hexadecimal.charAt(i)) << 4 | ByteUtil.fromHexChar(hexadecimal.charAt(i + 1)));
        }
        return bytes;
    }

    public static String toHexadecimal(byte[] bytes) {
        int length = bytes.length;
        char[] hexadecimal = new char[length * 2];
        for (int i = 0; i < length; ++i) {
            int v = bytes[i] & 0xFF;
            hexadecimal[i * 2] = ByteUtil.toHexChar(v >>> 4);
            hexadecimal[i * 2 + 1] = ByteUtil.toHexChar(v & 0xF);
        }
        return new String(hexadecimal);
    }

    public static String toHexadecimal(long number) {
        return ByteUtil.toHexadecimal(ByteUtil.toBytes(number));
    }

    public static int fromHexChar(char chr) {
        if (chr >= 'a' && chr <= 'f') {
            return chr - 87;
        }
        if (chr >= 'A' && chr <= 'F') {
            return chr - 55;
        }
        if (chr >= '0' && chr <= '9') {
            return chr - 48;
        }
        return 0;
    }

    public static char toHexChar(int number) {
        if (number >= 10 && number <= 15) {
            return (char)(87 + number);
        }
        if (number >= 0 && number <= 9) {
            return (char)(48 + number);
        }
        return '\u0000';
    }

    public static byte[] array(int length, byte value) {
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = value;
        }
        return result;
    }

    public static byte[] copy(byte[] bytes) {
        return ByteUtil.copy(bytes, 0, bytes.length);
    }

    public static byte[] copy(byte[] bytes, int start, int end) {
        int length = end - start;
        byte[] result = new byte[length];
        System.arraycopy(bytes, start, result, 0, length);
        return result;
    }

    public static byte[] concat(byte[] bytes1, byte[] bytes2) {
        byte[] result = new byte[bytes1.length + bytes2.length];
        System.arraycopy(bytes1, 0, result, 0, bytes1.length);
        System.arraycopy(bytes2, 0, result, bytes1.length, bytes2.length);
        return result;
    }

    public static byte[] replace(byte[] bytes, byte[] replacement, int index) {
        int i;
        byte[] result = new byte[bytes.length];
        for (i = 0; i < index; ++i) {
            result[i] = bytes[i];
        }
        for (i = 0; i < replacement.length; ++i) {
            result[index + i] = replacement[i];
        }
        return result;
    }

    public static boolean equalArrays(byte[] bytes1, byte[] bytes2) {
        if (bytes1.length != bytes2.length) {
            return false;
        }
        for (int i = 0; i < bytes1.length; ++i) {
            if (bytes1[i] == bytes2[i]) continue;
            return false;
        }
        return true;
    }
}

