/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.handler;

import androidx.annotation.NonNull;
import com.evrencoskun.tableview.TableView;
import com.evrencoskun.tableview.handler.ScrollHandler;
import com.evrencoskun.tableview.handler.SelectionHandler;
import com.evrencoskun.tableview.preference.Preferences;

public class PreferencesHandler {
    @NonNull
    private ScrollHandler scrollHandler;
    @NonNull
    private SelectionHandler selectionHandler;

    public PreferencesHandler(@NonNull TableView tableView) {
        this.scrollHandler = tableView.getScrollHandler();
        this.selectionHandler = tableView.getSelectionHandler();
    }

    @NonNull
    public Preferences savePreferences() {
        Preferences preferences = new Preferences();
        preferences.columnPosition = this.scrollHandler.getColumnPosition();
        preferences.columnPositionOffset = this.scrollHandler.getColumnPositionOffset();
        preferences.rowPosition = this.scrollHandler.getRowPosition();
        preferences.rowPositionOffset = this.scrollHandler.getRowPositionOffset();
        preferences.selectedColumnPosition = this.selectionHandler.getSelectedColumnPosition();
        preferences.selectedRowPosition = this.selectionHandler.getSelectedRowPosition();
        return preferences;
    }

    public void loadPreferences(@NonNull Preferences preferences) {
        this.scrollHandler.scrollToColumnPosition(preferences.columnPosition, preferences.columnPositionOffset);
        this.scrollHandler.scrollToRowPosition(preferences.rowPosition, preferences.rowPositionOffset);
        this.selectionHandler.setSelectedColumnPosition(preferences.selectedColumnPosition);
        this.selectionHandler.setSelectedRowPosition(preferences.selectedRowPosition);
    }
}

