/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.sort;

import android.util.Log;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractSorterViewHolder;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import com.evrencoskun.tableview.layoutmanager.ColumnHeaderLayoutManager;
import com.evrencoskun.tableview.sort.SortState;
import java.util.ArrayList;
import java.util.List;

public class ColumnSortHelper {
    private List<Directive> mSortingColumns = new ArrayList<Directive>();
    private ColumnHeaderLayoutManager mColumnHeaderLayoutManager;
    private static Directive EMPTY_DIRECTIVE = new Directive(-1, SortState.UNSORTED);

    public ColumnSortHelper(ColumnHeaderLayoutManager columnHeaderLayoutManager) {
        this.mColumnHeaderLayoutManager = columnHeaderLayoutManager;
    }

    private void sortingStatusChanged(int column, SortState sortState) {
        AbstractViewHolder holder = this.mColumnHeaderLayoutManager.getViewHolder(column);
        if (holder != null) {
            if (holder instanceof AbstractSorterViewHolder) {
                ((AbstractSorterViewHolder)holder).onSortingStatusChanged(sortState);
            } else {
                Log.e((String)ColumnSortHelper.class.getSimpleName(), (String)"For sorting process, column header view holders must be extended from AbstractSorterViewHolder class");
            }
        }
    }

    public void setSortingStatus(int column, SortState status) {
        Directive directive = this.getDirective(column);
        if (directive != EMPTY_DIRECTIVE) {
            this.mSortingColumns.remove(directive);
        }
        if (status != SortState.UNSORTED) {
            this.mSortingColumns.add(new Directive(column, status));
        }
        this.sortingStatusChanged(column, status);
    }

    public void clearSortingStatus() {
        this.mSortingColumns.clear();
    }

    public boolean isSorting() {
        return this.mSortingColumns.size() != 0;
    }

    public SortState getSortingStatus(int column) {
        return this.getDirective(column).direction;
    }

    private Directive getDirective(int column) {
        for (int i = 0; i < this.mSortingColumns.size(); ++i) {
            Directive directive = this.mSortingColumns.get(i);
            if (directive.column != column) continue;
            return directive;
        }
        return EMPTY_DIRECTIVE;
    }

    public class TableViewSorterException
    extends Exception {
        public TableViewSorterException() {
            super("For sorting process, column header view holders must be extended from AbstractSorterViewHolder class");
        }
    }

    private static class Directive {
        private int column;
        private SortState direction;

        public Directive(int column, SortState direction) {
            this.column = column;
            this.direction = direction;
        }
    }
}

