/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.listener.itemclick;

import android.support.v7.widget.RecyclerView;
import android.view.MotionEvent;
import android.view.View;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerView;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import com.evrencoskun.tableview.listener.itemclick.AbstractItemClickListener;

public class RowHeaderRecyclerViewItemClickListener
extends AbstractItemClickListener {
    public RowHeaderRecyclerViewItemClickListener(CellRecyclerView recyclerView, ITableView tableView) {
        super(recyclerView, tableView);
    }

    @Override
    protected boolean clickAction(RecyclerView view, MotionEvent e) {
        View childView = view.findChildViewUnder(e.getX(), e.getY());
        if (childView != null && this.mGestureDetector.onTouchEvent(e)) {
            AbstractViewHolder holder = (AbstractViewHolder)this.mRecyclerView.getChildViewHolder(childView);
            int row = holder.getAdapterPosition();
            if (!this.mTableView.isIgnoreSelectionColors()) {
                this.mSelectionHandler.setSelectedRowPosition(holder, row);
            }
            if (this.getTableViewListener() != null) {
                this.getTableViewListener().onRowHeaderClicked(holder, row);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void longPressAction(MotionEvent e) {
        if (this.mRecyclerView.getScrollState() != 0) {
            return;
        }
        View child = this.mRecyclerView.findChildViewUnder(e.getX(), e.getY());
        if (child != null && this.getTableViewListener() != null) {
            RecyclerView.ViewHolder holder = this.mRecyclerView.getChildViewHolder(child);
            this.getTableViewListener().onRowHeaderLongPressed(holder, holder.getAdapterPosition());
        }
    }
}

