/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.sort;

import com.evrencoskun.tableview.sort.ISortableModel;
import com.evrencoskun.tableview.sort.SortState;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class ColumnSortComparator
implements Comparator<List<ISortableModel>> {
    private static final String LOG_TAG = ColumnSortComparator.class.getSimpleName();
    private int m_nXPosition;
    private SortState m_nSortState;

    public ColumnSortComparator(int p_nXPosition, SortState p_nSortState) {
        this.m_nXPosition = p_nXPosition;
        this.m_nSortState = p_nSortState;
    }

    @Override
    public int compare(List<ISortableModel> t1, List<ISortableModel> t2) {
        Object o1 = t1.get(this.m_nXPosition).getContent();
        Object o2 = t2.get(this.m_nXPosition).getContent();
        if (this.m_nSortState == SortState.DESCENDING) {
            return this.compareContent(o2, o1);
        }
        return this.compareContent(o1, o2);
    }

    private int compareContent(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        Class<?> type = o1.getClass();
        if (Comparable.class.isAssignableFrom(type)) {
            return ((Comparable)o1).compareTo(o2);
        }
        if (type.getSuperclass() == Number.class) {
            return this.compare((Number)o1, (Number)o2);
        }
        if (type == String.class) {
            return ((String)o1).compareTo((String)o2);
        }
        if (type == Date.class) {
            return this.compare((Date)o1, (Date)o2);
        }
        if (type == Boolean.class) {
            return this.compare((Boolean)o1, (Boolean)o2);
        }
        return ((String)o1).compareTo((String)o2);
    }

    @Override
    public int compare(Number o1, Number o2) {
        double n2;
        double n1 = o1.doubleValue();
        if (n1 < (n2 = o2.doubleValue())) {
            return -1;
        }
        if (n1 > n2) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compare(Date o1, Date o2) {
        long n2;
        long n1 = o1.getTime();
        if (n1 < (n2 = o2.getTime())) {
            return -1;
        }
        if (n1 > n2) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compare(Boolean o1, Boolean o2) {
        boolean b2;
        boolean b1 = o1;
        if (b1 == (b2 = o2.booleanValue())) {
            return 0;
        }
        if (b1) {
            return 1;
        }
        return -1;
    }
}

